jQuery(document).ready(function($) {
    const digistore_connect_button = $('#digistore_connect_button');
    const elopage_connect_button = $('#elopage_connect_button');
    const marketplaces_created_counter = $('#affililabs-plugin-dashboard__marketplaces__counter');

    const {
        connected_text,
        save_success_title,
        save_success,
        save_error_title,
        save_error,
        save_error_unknown,
        connecting_marketplace_text
    } = affililabs_dashboard.i18n;
    const { nonce, admin_url } = affililabs_dashboard;

    function setup_digistore_button_handler() {
        const is_connected = digistore_connect_button.data('is-connected');
        const edit_url = digistore_connect_button.data('edit-url');

        digistore_connect_button.off('click');

        if (is_connected === true && edit_url) {
            digistore_connect_button.prop('disabled', false);
            digistore_connect_button.on('click', function() {
                window.location.href = edit_url;
            });
        } else {
            digistore_connect_button.prop('disabled', false);
            const original_button_text = digistore_connect_button.text();
            digistore_connect_button.on('click', function() {
                const button = $(this);
                const marketplace_type = button.data('marketplace-type');

                button.prop('disabled', true);
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show(connecting_marketplace_text);
                }

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'affililabs_create_supported_marketplace',
                        nonce: nonce,
                        marketplace_type: marketplace_type
                    },
                    success: function(response) {
                        if (response.success && response.data.status === 'ok') {
                            button.text(connected_text);
                            
                            let current_count = parseInt(marketplaces_created_counter.text());
                            if (!isNaN(current_count) && response.data.marketplace_id) {
                                if (button.data('is-connected') === false) {
                                    marketplaces_created_counter.text(current_count + 1);
                                }
                                const new_edit_url = admin_url + 'admin.php?page=affililabs-marketplace-edit&marketplace_id=' + response.data.marketplace_id + '&nonce=' + nonce;
                                button.data('edit-url', new_edit_url);
                            }
                            button.data('is-connected', true);
                            
                            if (window.affililabs_modal) {
                                window.affililabs_modal.success(
                                    save_success_title,
                                    save_success
                                );
                            }
                            setup_digistore_button_handler();

                        } else {
                            console.error('[Response.status.error] ' + response?.data?.message || 'There was an error while creating default marketplace');
                            button.text(original_button_text).prop('disabled', false);
                            if (window.affililabs_modal) {
                                window.affililabs_modal.error(
                                    save_error_title,
                                    response.data.message || save_error_unknown
                                );
                            }
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('[Response.error] There was an error at Ajax level');
                        button.text(original_button_text).prop('disabled', false);
                        if (window.affililabs_modal) {
                            window.affililabs_modal.error(
                                save_error_title,
                                xhr.responseJSON.data.message || save_error_unknown
                            );
                        }
                        console.error('AJAX Error:', status, error, xhr);
                    },
                    complete: function() {
                        if (window.affililabs_spinner) {
                            window.affililabs_spinner.hide();
                        }
                    }
                });
            });
        }
    }

    elopage_connect_button.prop('disabled', true);
    setup_digistore_button_handler();
});