<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

$criteria_args = array(
    'post_type' => AFFILILABS_CPT_CRITERION,
    'posts_per_page' => -1,
);
$criteria_query = new WP_Query($criteria_args);
$criteria = $criteria_query->posts;

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();
$video_frame = new AffiliLabs_VideoFrame();
$video_frame->load_scripts();
$video_frame->init();

wp_enqueue_style('affililabs-criteria', AFFILILABS_CRITERIA_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-criteria', AFFILILABS_CRITERIA_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
wp_localize_script('affililabs-criteria', 'affililabs_criteria', array(
    'nonce' => wp_create_nonce('affl_admin_nonce'),
    'i18n' => array(
        'delete_criteria_title' => esc_html__('Delete Criterion', 'affililabs'),
        'delete_criteria_confirm' => esc_html__('Are you sure you want to delete this criterion?', 'affililabs'),
        'delete_criteria_success' => esc_html__('Criterion deleted', 'affililabs'),
        'delete_criteria_error' => esc_html__('Failed to delete criterion', 'affililabs'),
        'delete_criteria_unknown' => esc_html__('An unknown error occurred while trying to delete the criterion.', 'affililabs'),
        'delete_criteria_success_message' => esc_html__('The criterion has been successfully deleted.', 'affililabs'),
        'delete_criteria_error_message' => esc_html__('There was an error while deleting the criterion. Please try again.', 'affililabs'),
        'delete_criteria_loading' => esc_html__('Deleting criteria...', 'affililabs'),
    ),
));
?>

<div class="affililabs-plugin">
    <?php $sidebar->render('criteria'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin__header">
            <h1><?php affl_print(esc_html__('Criteria', 'affililabs')); ?></h1>
            <?php $button->render(__('Add New Criterion', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-criteria-edit'), 'affl_admin_nonce', 'nonce'))); ?>
        </header>
        <section class="affililabs-plugin__intro">
            <div class="affililabs-plugin__intro__text">
                <div>
                  <p><b><?php affl_print(esc_html__("Manage Criteria", 'affililabs')); ?></b></p>
                  <p class="affililabs-plugin__intro__description"><?php affl_print(esc_html__('Create and manage criteria to be assigned to products, allowing for better organization and customization of product data. This feature enhances your ability to tailor product listings to meet specific needs and improve user experience.', 'affililabs')); ?></p>
                </div>
                <?php $button->render(__('Add New Criterion', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-criteria-edit'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            <div class="affililabs-plugin__intro__video">
                <?php $video_frame->render(''); ?>
            </div>
        </section>
        <section class="affililabs-plugin__list">
            <table class="affililabs-plugin__table">
                <thead>
                    <tr>
                        <th><?php affl_print(esc_html__('Criterion', 'affililabs')); ?></th>
                        <th class="affililabs-plugin__actions-header"><?php affl_print(esc_html__('Actions', 'affililabs')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($criteria)): ?>
                        <tr>
                            <td colspan="2"><?php affl_print(esc_html__('No criteria found.', 'affililabs')); ?></td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($criteria as $criterion): ?>
                            <?php $post = get_post($criterion); ?>
                            <tr>
                                <td class="affililabs-plugin__criterion-name">
                                    <?php affl_print(esc_html($post->post_title)); ?>
                                </td>
                                <td class="affililabs-plugin__actions">
                                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-criteria-edit&criterion_id=' . $post->ID), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__edit-btn"><?php affl_print(esc_html__('Edit', 'affililabs')); ?></a>
                                    <img src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" class="affililabs-plugin__trash-icon affililabs-plugin__delete-btn" data-criterion-id="<?php affl_print(esc_attr($post->ID)); ?>" data-criterion-name="<?php affl_print(esc_attr($post->post_title)); ?>" />
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </section>
    </main>
</div>
