jQuery(document).ready(function ($) {
  const {
    delete_criteria_title,
    delete_criteria_confirm,
    delete_criteria_success,
    delete_criteria_success_message,
    delete_criteria_error,
    delete_criteria_error_message,
    delete_criteria_unknown,
    delete_criteria_loading,
  } = affililabs_criteria.i18n;
  const { nonce } = affililabs_criteria;
  function delete_criteria(criteria_id) {
    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
          action: "affililabs_delete_criterion",
          criterion_id: criteria_id,
          nonce: nonce,
        },
        beforeSend: function() {
          if (window.affililabs_spinner) {
            window.affililabs_spinner.show(delete_criteria_loading);
          }
        },
        success: function (response) {
          console.log('[Response.success] Criteria deleted successfully:', response);
          if (response.success && response.data.status === 'ok') {
            $(`.affililabs-plugin__delete-btn[data-criterion-id="${criteria_id}"]`)
              .closest("tr")
              .remove();
            window.affililabs_modal.success(
              delete_criteria_success,
              delete_criteria_success_message
            );
          } else {
            console.error('[Response.data.status.error] There was an error deleting the criteria:', response.data);
            window.affililabs_modal.error(
              delete_criteria_error,
              delete_criteria_error_message + ": " + (response.data ? response.data.message : delete_criteria_unknown)
            );
          }
        },
        error: function (xhr, status, error) {
          console.error('[Response.error] There was an error deleting the criteria:', xhr, status, error);
          window.affililabs_modal.error(
            delete_criteria_error,
            'Error: ' + (error || xhr.responseJSON.data.message || delete_criteria_unknown)
          );
        },
        complete: function() {
          if (window.affililabs_spinner) {
            window.affililabs_spinner.hide();
          }
        }
      });
  }

  function add_listeners() {
      $('.affililabs-plugin__delete-btn').off('click').on('click', function() {
          const criteria_id = $(this).data('criterion-id');
          const criteria_name = $(this).data('criterion-name');
          window.affililabs_modal.confirm(
            delete_criteria_title,
            delete_criteria_confirm + ' "' + criteria_name + '"',
            function() {
              delete_criteria(criteria_id);
            }
          );
      });
  }

  add_listeners();
});
