<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'affililabs'));
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_CRITERIA_FILE);

// Nonce verification
if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
    wp_die(esc_html__('Security check failed.', 'affililabs'));
}
$criterion_id = isset($_GET['criterion_id']) ? intval($_GET['criterion_id']) : null;
$criteria_edit = new AFFLCriteriaEdit();
$criteria_edit->load_scripts();
$criteria_edit->render($criterion_id);

class AFFLCriteriaEdit {
    public function load_scripts() {
      wp_enqueue_style('affililabs-criteria-edit', AFFILILABS_CRITERIA_EDIT_CSS_URL, array(), AFFILILABS_VERSION);
      wp_enqueue_script('affililabs-criteria-edit', AFFILILABS_CRITERIA_EDIT_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
      wp_localize_script('affililabs-criteria-edit', 'affililabs_criteria_edit', array(
          'i18n' => array(
              'field_name' => esc_html__('Field Name', 'affililabs'),
              'field_type' => esc_html__('Field Type', 'affililabs'),
              'remove' => esc_html__('Remove', 'affililabs'),
              'save_success_title' => esc_html__('Success', 'affililabs'),
              'save_success_message' => esc_html__('Criterion saved successfully.', 'affililabs'),
              'save_error_title' => esc_html__('Error', 'affililabs'),
              'save_error_message' => esc_html__('Failed to save criterion.', 'affililabs'),
              'save_error_unknown' => esc_html__('An unknown error occurred while trying to save the criterion.', 'affililabs'),
          ),
          'nonce' => wp_create_nonce('affl_admin_nonce'),
          'ajax_url' => admin_url('admin-ajax.php')
      ));
    }

    public function render($criterion_id=null) {
        $criterion_details = array();

        if ($criterion_id) {
            try {
                if (class_exists('AFFLCriteriaService')) {
                    $criterion_details = AFFLCriteriaService::get_criterion($criterion_id);
                } else {
                     AFFL_LoggerService::log('AFFLCriteriaService not found in AFFLCriteriaEdit::render', 'ERROR');
                     $criterion_id = null;
                }
            } catch (Exception $e) {
                 AFFL_LoggerService::log("Error fetching criterion data for ID " . esc_html($criterion_id) . ": " . esc_html($e->getMessage()), 'ERROR');
                $criterion_id = null;
            }
        }

        if (empty($criterion_details)) {
             $criterion_details = array(
                'id' => null,
                'title' => '',
                'description' => '',
                'fields' => array(),
                'linked_products' => array(),
                'linked_categories' => array(),
                'linked_product_lists' => array(),
            );
        }

        $sidebar = new AffiliLabs_Sidebar();
        $sidebar->load_scripts();
        $navbar = new AffiliLabs_Navbar();
        $navbar->load_scripts();
        $button = new AffiliLabs_Button();
        $modal = new AffiliLabs_Modal();
        $modal->load_scripts();
        $modal->init();
        $spinner = new AffiliLabs_Spinner();
        $spinner->load_scripts();
        $spinner->init();
        $video_frame = new AffiliLabs_VideoFrame();
        $video_frame->load_scripts();
        $video_frame->init();

        ?>
        <div class="affililabs-plugin-criteria-edit">
            <?php $sidebar->render('criteria'); ?>
            <main class="affililabs-plugin__main">
                <?php $navbar->render(); ?>
                <header class="affililabs-plugin-criteria-edit__header">
                    <h1><?php affl_print($criterion_id ? esc_html__('Edit Criterion', 'affililabs') : esc_html__('Add New Criterion', 'affililabs')); ?></h1>
                    <?php $button->render(__('See your stats', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs')), AFFILILABS_ASSETS_PULSE_WHITE_SVG); ?>
                </header>
                <section class="affililabs-plugin-criteria-edit__intro">
                    <div class="affililabs-plugin-criteria-edit__intro__text">
                        <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                        <p class="affililabs-plugin-criteria-edit__intro__description"><?php affl_print(esc_html__('Create reusable sets of fields (criteria) that define attributes for your products. Link criteria to products, categories, or lists for streamlined data management.', 'affililabs')); ?></p>
                        <?php $button->render(__('See all Criteria', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-criteria')), AFFILILABS_ASSETS_COPY_SVG); ?>
                    </div>
                    <div class="affililabs-plugin-criteria-edit__intro__video">
                        <?php $video_frame->render(''); ?>
                    </div>
                </section>
                <section class="affililabs-plugin-criteria-edit__config">
                    <ul class="affililabs-plugin-criteria-edit__config__tabs">
                        <li class="affililabs-plugin-criteria-edit__config__tab affililabs-plugin-criteria-edit__config__tab--active" data-tab="basic"><?php affl_print(esc_html__('BASICS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-criteria-edit__config__tab" data-tab="fields"><?php affl_print(esc_html__('FIELDS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-criteria-edit__config__tab" data-tab="relationships"><?php affl_print(esc_html__('RELATIONSHIPS', 'affililabs')); ?></li>
                    </ul>

                    <div class="affililabs-plugin-criteria-edit__config__tab-content affililabs-plugin-criteria-edit__config__tab-content--active" data-tab-content="basic">
                        <h2><?php affl_print(esc_html__('Basic Information', 'affililabs')); ?></h2>
                        <input type="hidden" id="criterion-id" name="criterion_id" value="<?php affl_print(esc_attr($criterion_details['id'] ?? '')); ?>">
                        <div class="affililabs-plugin-criteria-edit__config__field">
                            <label for="criterion-title"><?php affl_print(esc_html__('Criterion Name', 'affililabs')); ?></label>
                            <input type="text" id="criterion-title" name="criterion_title" value="<?php affl_print(esc_attr($criterion_details['title'] ?? '')); ?>" required>
                        </div>
                        <div class="affililabs-plugin-criteria-edit__config__field">

                            <label for="criterion-description"><?php affl_print(esc_html__('Description', 'affililabs')); ?></label>
                            <textarea id="criterion-description" name="criterion_description"><?php affl_print(esc_textarea($criterion_details['description'] ?? '')); ?></textarea>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin__criterion-save-button" data-save-tab="basic"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>

                    <div class="affililabs-plugin-criteria-edit__config__tab-content" data-tab-content="fields">
                        <h2><?php affl_print(esc_html__('Fields Configuration', 'affililabs')); ?></h2>
                        <div id="criteria-fields-container">
                            <?php
                            $fields = $criterion_details['fields'] ?? [];
                            if(is_array($fields) && !empty($fields)):
                                foreach($fields as $index => $field):
                                    if (!is_array($field)) continue;
                                    $field_name = $field['name'] ?? '';
                                    $field_type = $field['type'] ?? 'text';
                                    $field_unit = $field['unit'] ?? '';
                                    $definition_id = $field['definition_id'] ?? null;
                            ?>
                                <div class="affililabs-plugin-criteria-edit__config__field" data-definition-id="<?php affl_print(esc_attr($definition_id)); ?>">
                                    <label for="criterion-field-name-<?php affl_print($index); ?>"><?php affl_print(esc_html__('Field Name', 'affililabs')); ?></label>
                                    <input type="text" class="affililabs-plugin__input" id="criterion-field-name-<?php affl_print($index); ?>" name="criterion_fields[<?php affl_print($index); ?>][name]" placeholder="Field Name" value="<?php affl_print(esc_attr($field_name)); ?>" />

                                    <label for="criterion-field-type-<?php affl_print($index); ?>"><?php affl_print(esc_html__('Field Type', 'affililabs')); ?></label>
                                    <select id="criterion-field-type-<?php affl_print($index); ?>" name="criterion_fields[<?php affl_print($index); ?>][type]" class="affl-w-100px field-type-select">
                                        <option value="text" <?php selected($field_type, 'text'); ?>>Text</option>
                                        <option value="number" <?php selected($field_type, 'number'); ?>>Number</option>
                                        <option value="boolean" <?php selected($field_type, 'boolean'); ?>>Boolean</option>
                                    </select>

                                    <div class="field-unit-container" style="<?php affl_print($field_type === 'number' ? 'display: flex;' : 'display: none;'); ?>">
                                        <label for="criterion-field-unit-<?php affl_print($index); ?>"><?php affl_print(esc_html__('Unit', 'affililabs')); ?></label>
                                        <input type="text" class="affililabs-plugin__input field-unit" id="criterion-field-unit-<?php affl_print($index); ?>" name="criterion_fields[<?php affl_print($index); ?>][unit]" placeholder="e.g. GB, MHz, etc." value="<?php affl_print(esc_attr($field_unit)); ?>" />
                                    </div>
                                    <button type="button" class="affililabs-plugin__button affililabs-plugin__button--danger remove-criterion-field"><?php affl_print(esc_html__('Remove', 'affililabs')); ?></button>
                                </div>
                            <?php
                                endforeach;
                            else:
                            ?>
                                <div class="affililabs-plugin-criteria-edit__config__field">
                                    <label for="criterion-field-name-0"><?php affl_print(esc_html__('Field Name', 'affililabs')); ?></label>
                                    <input type="text" class="affililabs-plugin__input" id="criterion-field-name-0" name="criterion_fields[0][name]" placeholder="Field Name" />

                                    <label for="criterion-field-type-0"><?php affl_print(esc_html__('Field Type', 'affililabs')); ?></label>
                                    <select id="criterion-field-type-0" name="criterion_fields[0][type]" class="affl-w-100px field-type-select">
                                        <option value="text">Text</option>
                                        <option value="number">Number</option>
                                        <option value="boolean">Boolean</option>
                                    </select>

                                    <div class="field-unit-container" style="display: none;">
                                        <label for="criterion-field-unit-0"><?php affl_print(esc_html__('Unit', 'affililabs')); ?></label>
                                        <input type="text" class="affililabs-plugin__input field-unit" id="criterion-field-unit-0" name="criterion_fields[0][unit]" placeholder="e.g. GB, MHz, etc." value="" />
                                    </div>
                                    <button type="button" class="affililabs-plugin__button affililabs-plugin__button--danger remove-criterion-field"><?php affl_print(esc_html__('Remove', 'affililabs')); ?></button>
                                </div>
                            <?php endif; ?>
                        </div>
                        <button type="button" id="add-criterion-field" class="affililabs-plugin__button affililabs-plugin__button--secondary"><?php affl_print(esc_html__('Add Field', 'affililabs')); ?></button>
                        <button class="affililabs-plugin__button affililabs-plugin__criterion-save-button affl-mt-10" data-save-tab="fields"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>

                    <div class="affililabs-plugin-criteria-edit__config__tab-content" data-tab-content="relationships">
                        <h2><?php affl_print(esc_html__('Relationships', 'affililabs')); ?></h2>

                        <div class="affililabs-plugin-criteria-edit__config__field">
                            <label><?php affl_print(esc_html__('Linked Categories', 'affililabs')); ?></label>
                            <div id="criterion-linked-categories" class="affililabs-plugin-criteria-edit__config__categories affililabs-plugin-criteria-edit__config__card">
                                <?php
                                $linked_categories = $criterion_details['linked_categories'] ?? [];
                                $categories = get_terms(array(
                                    'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
                                    'hide_empty' => false,
                                ));

                                $selected_category_ids = array();
                                if (is_array($linked_categories)) {
                                    $selected_category_ids = $linked_categories;
                                }

                                foreach ($categories as $category) {
                                    $checked = in_array($category->term_id, $selected_category_ids) ? 'checked' : '';
                                    ?>
                                    <div class="affililabs-plugin-criteria-edit__config__field-card">
                                        <input type="checkbox" class="affililabs-plugin-criteria-edit__config__categories-checkbox" id="linked-category-<?php affl_print(esc_attr($category->term_id)); ?>" name="criterion_linked_categories[]" value="<?php affl_print(esc_attr($category->term_id)); ?>" <?php affl_print($checked); ?> />
                                        <label for="linked-category-<?php affl_print(esc_attr($category->term_id)); ?>"><?php affl_print(esc_html($category->name)); ?></label>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>

                        <div class="affililabs-plugin-criteria-edit__config__field">
                            <label><?php affl_print(esc_html__('Linked Products', 'affililabs')); ?></label>
                            <div id="criterion-linked-products" class="affililabs-plugin-criteria-edit__config__products affililabs-plugin-criteria-edit__config__card">
                                <?php
                                $linked_products = $criterion_details['linked_products'] ?? [];
                                $products = get_posts(array(
                                    'post_type' => AFFILILABS_CPT_PRODUCT,
                                    'posts_per_page' => -1,
                                    'post_status' => 'any'
                                ));

                                $selected_product_ids = array();
                                if (is_array($linked_products)) {
                                    $selected_product_ids = $linked_products;
                                }

                                foreach ($products as $product) {
                                    $checked = in_array($product->ID, $selected_product_ids) ? 'checked' : '';
                                    ?>
                                    <div class="affililabs-plugin-criteria-edit__config__field-card">
                                        <input type="checkbox" class="affililabs-plugin-criteria-edit__config__products-checkbox" id="linked-product-<?php affl_print(esc_attr($product->ID)); ?>" name="criterion_linked_products[]" value="<?php affl_print(esc_attr($product->ID)); ?>" <?php affl_print($checked); ?> />
                                        <label for="linked-product-<?php affl_print(esc_attr($product->ID)); ?>"><?php affl_print(esc_html($product->post_title)); ?></label>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>

                        <button class="affililabs-plugin__button affililabs-plugin__criterion-save-button" data-save-tab="relationships"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>
                </section>
            </main>
        </div>
        <?php
    }
}
