jQuery(document).ready(function ($) {

  const {
    field_name,
    field_type,
    remove,
    save_success_title,
    save_success_message,
    save_error_title,
    save_error_message,
    save_error_unknown,
  } = affililabs_criteria_edit.i18n;

  const nonce = affililabs_criteria_edit.nonce;
  const ajax_url = window.ajaxurl || affililabs_criteria_edit.ajax_url;

  $('.affililabs-plugin-criteria-edit__config__tab').on('click', function(tab) {
    $('.affililabs-plugin-criteria-edit__config__tab')
      .removeClass('affililabs-plugin-criteria-edit__config__tab--active');
    $(tab.target).addClass('affililabs-plugin-criteria-edit__config__tab--active');

    $('.affililabs-plugin-criteria-edit__config__tab-content')
      .removeClass('affililabs-plugin-criteria-edit__config__tab-content--active');
    $(`.affililabs-plugin-criteria-edit__config__tab-content[data-tab-content="${
      $(tab.target).data('tab')}"]`)
      .addClass('affililabs-plugin-criteria-edit__config__tab-content--active');
  });

  $(document).on('change', '.field-type-select', function() {
    const unit_container = $(this).closest('.affililabs-plugin-criteria-edit__config__field').find('.field-unit-container');
    if ($(this).val() === 'number') {
      unit_container.show();
    } else {
      unit_container.hide();
    }
  });

  let field_count = $('#criteria-fields-container .affililabs-plugin-criteria-edit__config__field').length - 1;
  if (field_count < 0) field_count = 0;

  $("#add-criterion-field").on("click", function (e) {
    e.preventDefault();

    field_count++;

    const new_field_row = `
      <div class="affililabs-plugin-criteria-edit__config__field affl-flex-center">
        <label for="criterion-field-name-${field_count}">${field_name}</label>
        <input type="text" class="affililabs-plugin__input" id="criterion-field-name-${field_count}" name="criterion_fields[${field_count}][name]" placeholder="Field Name" />

        <label for="criterion-field-type-${field_count}">${field_type}</label>
        <select id="criterion-field-type-${field_count}" name="criterion_fields[${field_count}][type]" class="affl-w-100px field-type-select">
            <option value="text">Text</option>
            <option value="number">Number</option>
            <option value="boolean">Boolean</option>
        </select>

        <div class="field-unit-container" style="display: none;">
          <label for="criterion-field-unit-${field_count}">Unit</label>
          <input type="text" class="affililabs-plugin__input field-unit" id="criterion-field-unit-${field_count}" name="criterion_fields[${field_count}][unit]" placeholder="e.g. GB, MHz, etc." value="" />
        </div>

        <button type="button" class="affililabs-plugin__button affililabs-plugin__button--danger remove-criterion-field">${remove}</button>
      </div>
    `;
    $("#criteria-fields-container").append(new_field_row);
  });

  $("#criteria-fields-container").on('click', '.remove-criterion-field', function(e) {
    e.preventDefault();
    $(this).closest('.affililabs-plugin-criteria-edit__config__field').remove();
  });

  $('.affililabs-plugin__criterion-save-button').on('click', function(e) {
    e.preventDefault();
    const save_button = $(this);
    const original_button_text = save_button.text();
    save_button.prop('disabled', true);

    const criterion_data = {};
    criterion_data.id = $('#criterion-id').val().trim();
    criterion_data.title = $('#criterion-title').val().trim();
    criterion_data.description = $('#criterion-description').val().trim();

    criterion_data.fields = [];
    $('#criteria-fields-container .affililabs-plugin-criteria-edit__config__field').each(function(index) {
      const field_name_val = $(this).find('input[name^="criterion_fields"][name$="[name]"]').val().trim();
      const field_type_val = $(this).find('select[name^="criterion_fields"][name$="[type]"]').val().trim();
      const field_unit_val = field_type_val === 'number' ? $(this).find('input[name^="criterion_fields"][name$="[unit]"]').val().trim() : '';
      const field_slug_val = field_name_val.toLowerCase().replace(/[^a-z0-9]+/g, '_');
      const definition_id_val = $(this).data('definition-id');

      if (field_name_val) {
        const field_obj = {
          name: field_name_val,
          slug: field_slug_val,
          type: field_type_val,
          unit: field_unit_val
        };
        if (definition_id_val) {
          field_obj['definition_id'] = definition_id_val;
        }
        criterion_data.fields.push(field_obj);
      }
    });

    criterion_data.linked_products = [];
    $('#criterion-linked-products').find('input:checked').each(function() {
        criterion_data.linked_products.push($(this).val());
    });
    criterion_data.linked_categories = [];
    $('#criterion-linked-categories').find('input:checked').each(function() {
        criterion_data.linked_categories.push($(this).val());
    });

    console.log('Criterion data to save:', criterion_data);

    $.ajax({
      url: ajax_url,
      type: "POST",
      data: {
        action: "affililabs_save_criterion",
        criterion_data: JSON.stringify(criterion_data),
        nonce: nonce
      },
      beforeSend: function() {
        if (window.affililabs_spinner) {
          window.affililabs_spinner.show('Saving criterion...');
        }
      },
      success: function(response) {
        console.log('Criterion saved successfully:', response);

        if (response.success && response.data.status === 'ok') {
          window.affililabs_modal.success(
            save_success_title,
            save_success_message
          );

          if (!criterion_data.id && response.data.criterion_id) {
            const new_criterion_id = response.data.criterion_id;
            $('#criterion-id').val(new_criterion_id);

            const new_url = new URL(window.location.href);
            new_url.searchParams.set('criterion_id', new_criterion_id);
            window.history.pushState({ path: new_url.href }, '', new_url.href);
          }
        } else {
          console.error('[Response.status.error] Error saving criterion:', response.data);
          window.affililabs_modal.error(
            save_error_title,
            response.data?.message || save_error_message
          );
        }
      },
      error: function(xhr, status, error) {
        console.error('[Response.error] Error saving criterion:', xhr, status, error);
        window.affililabs_modal.error(
          save_error_title,
          xhr.responseJSON.data.message || save_error_unknown
        );
      },
      complete: function() {
        save_button.prop('disabled', false).text(original_button_text);
        if (window.affililabs_spinner) {
          window.affililabs_spinner.hide();
        }
      }
    });
  });
});
