<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();

wp_enqueue_style('affililabs-classic-links', AFFILILABS_CLASSIC_LINKS_CSS_URL, array(), AFFILILABS_VERSION);
?>

<div class="affililabs-plugin">
    <?php $sidebar->render('classic-links'); ?>
    <main id="affililabs-plugin__classic-links" class="affililabs-plugin__main">
        <?php $navbar->render(); ?>

        <section class="affililabs-plugin__container">
            <div class="affililabs-plugin__card affililabs-plugin__card--info">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('AffiliLabs Classic', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Welcome to the AffiliLabs Classic interface! Here you\'ll find direct access to all the traditional WordPress post type management screens. These powerful tools give you complete control over your affiliate marketing content with the familiar WordPress editing experience you know and love.', 'affililabs')); ?>
                    </p>
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Each section below provides a gateway to manage different aspects of your affiliate ecosystem - from marketplaces and products to comparison criteria and lists. Click any button to dive into the full-featured WordPress editor for that content type.', 'affililabs')); ?>
                    </p>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__content-grid">
            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h2 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Marketplaces', 'affililabs')); ?></h2>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Manage your affiliate marketplaces where digital products are sold. Configure marketplace settings, track performance, and organize your affiliate partnerships all in one place.', 'affililabs')); ?>
                    </p>
                    <a href="<?php affl_print(admin_url('edit.php?post_type=' . AFFILILABS_CPT_MARKETPLACE)); ?>" target="_blank" class="affililabs-plugin__button affililabs-plugin__button--primary">
                        <?php affl_print(esc_html__('View All Marketplaces', 'affililabs')); ?>
                    </a>
                </div>
            </div>

            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h2 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Product Categories', 'affililabs')); ?></h2>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Organize your products into meaningful categories. Create hierarchical structures that make it easy for your visitors to find exactly what they\'re looking for.', 'affililabs')); ?>
                    </p>
                    <a href="<?php affl_print(admin_url('edit-tags.php?taxonomy=' . AFFILILABS_TAXONOMY_PRODUCT_CATEGORY . '&post_type=' . AFFILILABS_CPT_PRODUCT)); ?>" target="_blank" class="affililabs-plugin__button affililabs-plugin__button--primary">
                        <?php affl_print(esc_html__('Manage Categories', 'affililabs')); ?>
                    </a>
                </div>
            </div>

            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h2 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Products', 'affililabs')); ?></h2>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Access the complete WordPress editor for your affiliate products. Create detailed product pages with rich content, images, and all the information your audience needs to make informed decisions.', 'affililabs')); ?>
                    </p>
                    <a href="<?php affl_print(admin_url('edit.php?post_type=' . AFFILILABS_CPT_PRODUCT)); ?>" target="_blank" class="affililabs-plugin__button affililabs-plugin__button--primary">
                        <?php affl_print(esc_html__('View All Products', 'affililabs')); ?>
                    </a>
                </div>
            </div>

            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h2 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Criteria', 'affililabs')); ?></h2>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Define reusable comparison criteria for your products. Build consistent evaluation frameworks that help your audience compare products across multiple dimensions.', 'affililabs')); ?>
                    </p>
                    <a href="<?php affl_print(admin_url('edit.php?post_type=' . AFFILILABS_CPT_CRITERION)); ?>" target="_blank" class="affililabs-plugin__button affililabs-plugin__button--primary">
                        <?php affl_print(esc_html__('Manage Criteria', 'affililabs')); ?>
                    </a>
                </div>
            </div>

            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h2 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Comparison Lists', 'affililabs')); ?></h2>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text">
                        <?php affl_print(esc_html__('Create powerful comparison tables that showcase multiple products side-by-side. Help your visitors make quick, informed decisions with clear, visual comparisons.', 'affililabs')); ?>
                    </p>
                    <a href="<?php affl_print(admin_url('edit.php?post_type=' . AFFILILABS_CPT_COMPARISON_TABLE)); ?>" target="_blank" class="affililabs-plugin__button affililabs-plugin__button--primary">
                        <?php affl_print(esc_html__('View All Lists', 'affililabs')); ?>
                    </a>
                </div>
            </div>
        </section>
    </main>
</div>
