<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Abstract class defining the contract for product finder services.
 *
 * Each marketplace-specific finder should extend this class and implement the find_products method.
 */
abstract class AFFLProductFinder {

    /**
     * Finds products based on a keyword for a specific marketplace.
     *
     * @param string $keyword The search term.
     * @param array $filters Optional filters for the search.
     * @return array An array of product data, formatted consistently across implementations.
     *               Each product should be an associative array. Returns empty array on failure or no results.
     * @throws Exception If an error occurs during the API call or data processing.
     */
    abstract public function find_products(string $keyword, array $filters = []): array;

}
