<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

function affl_register_template_post_type() {
    $labels = array(
        'name'                => _x('Templates', 'Post Type General Name', 'affililabs'),
        'singular_name'       => _x('Template', 'Post Type Singular Name', 'affililabs'),
        'menu_name'           => __('Templates', 'affililabs'),
        'parent_item_colon'   => __('Parent Template', 'affililabs'),
        'all_items'           => __('All Templates', 'affililabs'),
        'view_item'           => __('View Template', 'affililabs'),
        'add_new_item'        => __('Add New Template', 'affililabs'),
        'add_new'             => __('Add New', 'affililabs'),
        'edit_item'           => __('Edit Template', 'affililabs'),
        'update_item'         => __('Update Template', 'affililabs'),
        'search_items'        => __('Search Template', 'affililabs'),
        'not_found'           => __('Not Found', 'affililabs'),
        'not_found_in_trash'  => __('Not found in Trash', 'affililabs'),
    );

    $args = array(
        'labels'              => $labels,
        'description'         => __('Reusable templates for comparison tables and listicles', 'affililabs'),
        'supports'            => array('title', 'author'), // Keep title support
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => false,
        'show_in_menu'        => false,
        'show_in_nav_menus'   => false,
        'show_in_admin_bar'   => false,
        'can_export'          => true,
        'has_archive'         => false,
        'exclude_from_search' => true,
        'publicly_queryable'  => true,
        'rewrite'             => false,
        'capability_type'     => 'post',
        'menu_icon'           => 'dashicons-layout',
    );

    register_post_type('affl_template', $args); //@TODO: create const for this post type
}

add_action('init', 'affl_register_template_post_type');
