<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AffiliLabsProductCPT {
    public static function register() {
        $product_slug = get_option(AFFILILABS_PRODUCT_SLUG_OPTION, AFFILILABS_CPT_PRODUCT);
        $args = array(
            'hierarchical'        => true,
            'labels'              => array(
                'name'              => _x('Product Categories', 'taxonomy general name', 'affililabs'),
                'singular_name'     => _x('Product Category', 'taxonomy singular name', 'affililabs'),
                'search_items'      => __('Search Product Categories', 'affililabs'),
                'all_items'         => __('All Product Categories', 'affililabs'),
                'parent_item'       => __('Parent Product Category', 'affililabs'),
                'parent_item_colon' => __('Parent Product Category:', 'affililabs'),
                'edit_item'         => __('Edit Product Category', 'affililabs'),
                'update_item'       => __('Update Product Category', 'affililabs'),
                'add_new_item'      => __('Add New Product Category', 'affililabs'),
                'new_item_name'     => __('New Product Category Name', 'affililabs'),
                'menu_name'         => __('Product Categories', 'affililabs'),
            ),
            'show_ui'             => true,
            'show_in_menu'        => false,
            'show_admin_column'   => true,
            'query_var'           => true,
            'public'              => true,
            'publicly_queryable'  => true,
            'show_in_rest'        => true,
            'rewrite'             => array('slug' => $product_slug . '/category', 'with_front' => true),
            'update_count_callback' => '_update_generic_term_count'
        );

        register_taxonomy( AFFILILABS_TAXONOMY_PRODUCT_CATEGORY, array( AFFILILABS_CPT_PRODUCT ), $args );
        //@TODO: Register taxonomy for product tags instead of using post_tag
        
        $labels = array(
            'name'               => _x( 'Products', 'post type general name', 'affililabs'),
            'singular_name'      => _x( 'Product', 'post type singular name', 'affililabs'),
            'menu_name'          => _x( 'Products', 'admin menu', 'affililabs'),
            'name_admin_bar'     => _x( 'Product', 'add new on admin bar', 'affililabs'),
            'add_new'            => _x( 'Add New', 'Product', 'affililabs'),
            'add_new_item'       => __( 'Add New Product', 'affililabs'),
            'new_item'           => __( 'New Product', 'affililabs'),
            'edit_item'          => __( 'Edit Product', 'affililabs'),
            'view_item'          => __( 'View Product', 'affililabs'),
            'all_items'          => __( 'All Products', 'affililabs'),
            'search_items'       => __( 'Search Products', 'affililabs'),
            'parent_item_colon'  => __( 'Parent Products:', 'affililabs'),
            'not_found'          => __( 'No Products found.', 'affililabs'),
            'not_found_in_trash' => __( 'No Products found in Trash.', 'affililabs')
        );

        $args = array(
            'labels'             => $labels,
            'description'        => __( 'List of products sold on marketplaces.', 'affililabs' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_in_rest'       => true,
            'show_ui'            => true,
            'show_in_menu'       => AFFILILABS_CLASSIC_SLUG,
            'menu_position'      => 3,
            'menu_icon'          => 'dashicons-cart',
            'query_var'          => true,
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'trackbacks', 'custom-fields', 'comments', 'revisions', 'page-attributes', 'post-formats' ),
            'taxonomies'         => array( 'post_tag', AFFILILABS_TAXONOMY_PRODUCT_CATEGORY ),
            'rewrite'            => array( 'slug' => $product_slug,'with_front' => true ),
        );

        register_post_type( AFFILILABS_CPT_PRODUCT, $args );

        if (get_option(AFFILILABS_HIDE_PRODUCT_SLUG_OPTION, 0)) {
            add_filter('post_type_link', array('AffiliLabsProductCPT', 'remove_product_slug'), 10, 2);
            add_action('pre_get_posts', array('AffiliLabsProductCPT', 'add_product_to_query'));
        }

        add_action('pre_get_posts', array('AffiliLabsProductCPT', 'intercept_category_archive_query'));
        add_filter('post_type_link', array('AffiliLabsProductCPT', 'filter_virtual_post_link'), 10, 2);
    }

    public static function intercept_category_archive_query($query) {
        if (is_admin() || !$query->is_main_query() || AFFLSettingsService::get_enable_all_categories_page() != 1) {
            return;
        }

        if (isset($_SERVER['REQUEST_URI']) && strpos(esc_url_raw(wp_unslash($_SERVER['REQUEST_URI'])), 'post-new.php?post_type=affl_product') !== false) {
            return;
        }

        $product_slug = get_option(AFFILILABS_PRODUCT_SLUG_OPTION, AFFILILABS_CPT_PRODUCT);
        $category_root_slug = $product_slug . '/category';
        $request_path = trim(wp_parse_url(esc_url_raw(wp_unslash($_SERVER['REQUEST_URI'])), PHP_URL_PATH), '/');
        
        if ($request_path !== $category_root_slug) {
            return;
        }
        
        $query->set('name', '');
        $query->set('pagename', '');
        
        $query->set('post_type', AFFILILABS_CPT_PRODUCT);
        $query->set('affl_is_virtual_category_archive', true);
        
        $query->is_home = false;
        $query->is_singular = false;
        $query->is_single = false;
        $query->is_page = false;
        $query->is_tax = false;
        $query->is_archive = true;
        $query->is_post_type_archive = true;
        $query->is_404 = false;
        
        $query->queried_object = get_post_type_object(AFFILILABS_CPT_PRODUCT);
        $query->queried_object_id = 0;

        add_filter('the_posts', array('AffiliLabsProductCPT', 'provide_virtual_category_posts'), 10, 2);
        add_filter('get_the_archive_title', array('AffiliLabsProductCPT', 'set_virtual_archive_title'), 10, 1);
        add_filter('the_title', array('AffiliLabsProductCPT', 'virtual_post_title'), 10, 2);
        add_filter('the_excerpt', array('AffiliLabsProductCPT', 'virtual_post_excerpt'));
        add_filter('get_the_archive_description', array('AffiliLabsProductCPT', 'virtual_archive_description'));
        add_filter('pre_get_document_title', array('AffiliLabsProductCPT', 'virtual_archive_browser_title_override'), 9999);
        add_filter('post_class', array('AffiliLabsProductCPT', 'virtual_post_class'), 10, 3);
    }
    
    public static function set_virtual_archive_title($title) {
        if (get_query_var('affl_is_virtual_category_archive')) {
            remove_filter('get_the_archive_title', array('AffiliLabsProductCPT', 'set_virtual_archive_title'), 10);
            return __('Product Categories', 'affililabs');
        }
        return $title;
    }

    public static function provide_virtual_category_posts($posts, $query) {
        if (!$query->get('affl_is_virtual_category_archive')) {
            return $posts;
        }

        remove_filter('the_posts', array('AffiliLabsProductCPT', 'provide_virtual_category_posts'), 10);

        $terms = get_terms([
            'taxonomy'   => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
            'hide_empty' => false,
            'parent'     => 0,
        ]);

        if (is_wp_error($terms) || empty($terms)) {
            return [];
        }

        $virtual_posts = [];
        foreach ($terms as $term) {
            $post = new WP_Post((object)[
                'ID'             => $term->term_id,
                'post_author'    => 1,
                'post_date'      => current_time('mysql'),
                'post_date_gmt'  => current_time('mysql', 1),
                'post_content'   => $term->description,
                'post_title'     => $term->name,
                'post_excerpt'   => $term->description,
                'post_status'    => 'publish',
                'comment_status' => 'closed',
                'ping_status'    => 'closed',
                'post_password'  => '',
                'post_name'      => $term->slug,
                'to_ping'        => '',
                'pinged'         => '',
                'post_modified'  => current_time('mysql'),
                'post_modified_gmt' => current_time('mysql', 1),
                'post_content_filtered' => '',
                'post_parent'    => 0,
                'guid'           => get_term_link($term),
                'menu_order'     => 0,
                'post_type'      => AFFILILABS_CPT_PRODUCT,
                'post_mime_type' => '',
                'comment_count'  => 0,
                'filter'         => 'raw',
            ]);
            $virtual_posts[] = $post;
        }
        
        $query->post_count = count($virtual_posts);
        
        return $virtual_posts;
    }

    public static function virtual_post_title($title, $id) {
        if (!get_query_var('affl_is_virtual_category_archive') || !in_the_loop()) {
            return $title;
        }
    
        $is_virtual_post = !get_post($id);
        if ($is_virtual_post) {
            $term = get_term($id, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY);
            if ($term && !is_wp_error($term)) {
                return '<h2>' . esc_html($term->name) . '</h2>';
            }
        }
        return $title;
    }

    public static function virtual_post_excerpt($excerpt) {
        if (get_query_var('affl_is_virtual_category_archive') && in_the_loop()) {
            $term_id = get_the_ID();
            $term = get_term($term_id, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY);
            if ($term && !is_wp_error($term)) {
                return esc_html($term->description) ??  '';
            }
            return '';
        }
        return $excerpt;
    }

    public static function virtual_archive_description($description) {
        if (get_query_var('affl_is_virtual_category_archive')) {
            return __('List of product categories available in the marketplaces.', 'affililabs');
        }
        return $description;
    }

    public static function virtual_archive_browser_title_override($title) {
        if (get_query_var('affl_is_virtual_category_archive')) {
            return __('Product Categories', 'affililabs') . ' | ' . get_bloginfo('name');
        }
        return $title;
    }

    public static function virtual_post_class($classes, $class, $post_id) {
        if (get_query_var('affl_is_virtual_category_archive')) {
            $is_virtual_post = !get_post($post_id);
            if ($is_virtual_post) {
                $classes[] = 'virtual-category-post';
            }
        }
        return $classes;
    }

    public static function filter_virtual_post_link($post_link, $post) {
        if ($post->post_type !== AFFILILABS_CPT_PRODUCT) {
            return $post_link;
        }

        $is_virtual_post = ! get_post($post->ID);
        if ($is_virtual_post) {
             return get_term_link($post->ID, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY);
        }

        return $post_link;
    }

    public static function remove_product_slug($post_link, $post) {
        if (get_option(AFFILILABS_HIDE_PRODUCT_SLUG_OPTION, 0) && AFFILILABS_CPT_PRODUCT === $post->post_type && 'publish' === $post->post_status) {
            $product_slug = get_option(AFFILILABS_PRODUCT_SLUG_OPTION, AFFILILABS_CPT_PRODUCT);
            $post_link = str_replace('/' . $product_slug . '/', '/', $post_link);
        }
        return $post_link;
    }

    public static function add_product_to_query($query) {
        if (get_option(AFFILILABS_HIDE_PRODUCT_SLUG_OPTION, 0) && $query->is_main_query() && isset($query->query['name'])) {
            $query->set('post_type', array('post', 'page', AFFILILABS_CPT_PRODUCT));
        }
    }

    public static function flush_product() {
      AffiliLabsProductCPT::register();
      flush_rewrite_rules();
  }
}

register_activation_hook(AFFILILABS_PLUGIN_FILE, array('AffiliLabsProductCPT', 'flush_product'));
add_action( 'init', array( 'AffiliLabsProductCPT', 'register' ), 5 );
