<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AffiliLabsMarketplaceCPT {
    public static function register() {
        $labels = array(
            'name'               => _x( 'Marketplaces', 'post type general name', 'affililabs'),
            'singular_name'      => _x( 'Marketplace', 'post type singular name', 'affililabs'),
            'menu_name'          => _x( 'Marketplaces', 'admin menu', 'affililabs'),
            'name_admin_bar'     => _x( 'Marketplace', 'add new on admin bar', 'affililabs'),
            'add_new'            => _x( 'Add New', 'Marketplace', 'affililabs'),
            'add_new_item'       => __( 'Add New Marketplace', 'affililabs'),
            'new_item'           => __( 'New Marketplace', 'affililabs'),
            'edit_item'          => __( 'Edit Marketplace', 'affililabs'),
            'view_item'          => __( 'View Marketplace', 'affililabs'),
            'all_items'          => __( 'All Marketplaces', 'affililabs'),
            'search_items'       => __( 'Search Marketplaces', 'affililabs'),
            'parent_item_colon'  => __( 'Parent Marketplaces:', 'affililabs'),
            'not_found'          => __( 'No Marketplaces found.', 'affililabs'),
            'not_found_in_trash' => __( 'No Marketplaces found in Trash.', 'affililabs')
        );

        $args = array(
            'labels'             => $labels,
            'description'        => __( 'List of marketplaces where digital products are sold.', 'affililabs' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => AFFILILABS_CLASSIC_SLUG,
            'menu_position'      => 1,
            'menu_icon'          => 'dashicons-store',
            'query_var'          => true,
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
            'taxonomies'         => array( AFFILILABS_TAXONOMY_MARKETPLACE_CATEGORY )
        );

        register_post_type( AFFILILABS_CPT_MARKETPLACE, $args );

        $args = array(
            'hierarchical'      => true,
            'labels'            => array(
                'name'              => _x( 'Marketplace Categories', 'taxonomy general name', 'affililabs' ),
                'singular_name'     => _x( 'Marketplace Category', 'taxonomy singular name', 'affililabs' ),
                'search_items'      => __( 'Search Marketplace Categories', 'affililabs' ),
                'all_items'         => __( 'All Marketplace Categories', 'affililabs' ),
                'parent_item'       => __( 'Parent Marketplace Category', 'affililabs' ),
                'parent_item_colon' => __( 'Parent Marketplace Category:', 'affililabs' ),
                'edit_item'         => __( 'Edit Marketplace Category', 'affililabs' ),
                'update_item'       => __( 'Update Marketplace Category', 'affililabs' ),
                'add_new_item'      => __( 'Add New Marketplace Category', 'affililabs' ),
                'new_item_name'     => __( 'New Marketplace Category Name', 'affililabs' ),
                'menu_name'         => __( 'Marketplace Categories', 'affililabs' ),
            ),
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true
        );

        register_taxonomy( AFFILILABS_TAXONOMY_MARKETPLACE_CATEGORY, array( AFFILILABS_CPT_MARKETPLACE ), $args );
    }

    public static function flush_marketplace() {
      AffiliLabsMarketplaceCPT::register();
      flush_rewrite_rules();
  }
}

register_activation_hook(AFFILILABS_PLUGIN_FILE, array('AffiliLabsMarketplaceCPT', 'flush_marketplace'));
add_action( 'init', array( 'AffiliLabsMarketplaceCPT', 'register' ) );
