<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AFFLCriteriaCPT {
    public static function register() {
        $labels = array(
            'name'               => _x( 'Criteria', 'post type general name', 'affililabs'),
            'singular_name'      => _x( 'Criterion', 'post type singular name', 'affililabs'),
            'menu_name'          => _x( 'Criteria', 'admin menu', 'affililabs'),
            'name_admin_bar'     => _x( 'Criterion', 'add new on admin bar', 'affililabs'),
            'add_new'            => _x( 'Add New', 'Criterion', 'affililabs'),
            'add_new_item'       => __( 'Add New Criterion', 'affililabs'),
            'new_item'           => __( 'New Criterion', 'affililabs'),
            'edit_item'          => __( 'Edit Criterion', 'affililabs'),
            'view_item'          => __( 'View Criterion', 'affililabs'),
            'all_items'          => __( 'All Criteria', 'affililabs'),
            'search_items'       => __( 'Search Criteria', 'affililabs'),
            'parent_item_colon'  => __( 'Parent Criteria:', 'affililabs'),
            'not_found'          => __( 'No Criteria found.', 'affililabs'),
            'not_found_in_trash' => __( 'No Criteria found in Trash.', 'affililabs')
        );

        $args = array(
            'labels'             => $labels,
            'description'        => __( 'Reusable sets of fields (criteria) to define product attributes.', 'affililabs' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => AFFILILABS_CLASSIC_SLUG,
            'menu_position'      => 4,
            'menu_icon'          => 'dashicons-forms',
            'query_var'          => true,
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'supports'           => array( 'title', 'editor', 'thumbnail', 'custom-fields' )
        );

        register_post_type( AFFILILABS_CPT_CRITERION, $args );
    }

    public static function flush_criteria() {
      AFFLCriteriaCPT::register();
      flush_rewrite_rules();
  }
}


register_activation_hook(AFFILILABS_PLUGIN_FILE, array('AFFLCriteriaCPT', 'flush_criteria'));
add_action( 'init', array( 'AFFLCriteriaCPT', 'register' ) );

