<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AFFLComparisonTableCPT {

    public static function register() {
        $labels = array(
            'name'                  => __('Lists', 'affililabs'),
            'singular_name'         => __('List', 'affililabs'),
            'menu_name'             => __('Lists', 'affililabs'),
            'name_admin_bar'        => __('List', 'affililabs'),
            'archives'              => __('List Archives', 'affililabs'),
            'attributes'            => __('List Attributes', 'affililabs'),
            'parent_item_colon'     => __('Parent List:', 'affililabs'),
            'all_items'             => __('All Lists', 'affililabs'),
            'add_new_item'          => __('Add New List', 'affililabs'),
            'add_new'               => __('Add New', 'affililabs'),
            'new_item'              => __('New List', 'affililabs'),
            'edit_item'             => __('Edit List', 'affililabs'),
            'update_item'           => __('Update List', 'affililabs'),
            'view_item'             => __('View List', 'affililabs'),
            'view_items'            => __('View Lists', 'affililabs'),
            'search_items'          => __('Search List', 'affililabs'),
            'not_found'             => __('Not found', 'affililabs'),
            'not_found_in_trash'    => __('Not found in Trash', 'affililabs'),
            'featured_image'        => __('Featured Image', 'affililabs'),
            'set_featured_image'    => __('Set featured image', 'affililabs'),
            'remove_featured_image' => __('Remove featured image', 'affililabs'),
            'use_featured_image'    => __('Use as featured image', 'affililabs'),
            'insert_into_item'      => __('Insert into list', 'affililabs'),
            'uploaded_to_this_item' => __('Uploaded to this list', 'affililabs'),
            'items_list'            => __('Lists list', 'affililabs'),
            'items_list_navigation' => __('Lists list navigation', 'affililabs'),
            'filter_items_list'     => __('Filter lists list', 'affililabs'),
        );
        $args = array(
            'label'                 => __('List', 'affililabs'),
            'description'           => __('Lists (Comparison Tables) for products', 'affililabs'),
            'labels'                => $labels,
            'supports'              => array('title', 'editor'),
            'hierarchical'          => true,
            'public'                => true,
            'show_ui'               => true,
            'show_in_menu'          => AFFILILABS_CLASSIC_SLUG,
            'menu_position'         => 5,
            'menu_icon'             => 'dashicons-media-text',
            'show_in_admin_bar'     => true,
            'show_in_nav_menus'     => true,
            'can_export'            => true,
            'exclude_from_search'   => true,
            'publicly_queryable'    => true,
            'capability_type'       => 'post',
            'rewrite'               => false,
        );
        register_post_type(AFFILILABS_CPT_COMPARISON_TABLE, $args);
    }

    public static function flush_comparison_table() {
        AFFLComparisonTableCPT::register();
        flush_rewrite_rules();
    }
}

register_activation_hook(AFFILILABS_PLUGIN_FILE, array('AFFLComparisonTableCPT', 'flush_comparison_table'));
add_action('init', array('AFFLComparisonTableCPT', 'register'));

