<?php

if (!defined('ABSPATH')) {
    exit;
}

class AFFLMetaboxPostComparisonTable {
    
    public function __construct() {
        add_action('add_meta_boxes', array($this, 'add_metabox'));
        add_action('save_post', array($this, 'save'));
    }
    
    public function add_metabox($post_type) {
        $post_types = array('post', 'page');
        
        if (!in_array($post_type, $post_types)) {
            AFFL_LoggerService::debug('Skipping metabox for post type: ' . esc_html($post_type), 'DEBUG');
            return;
        }

        add_meta_box(
            'affililabs-comparison-table-association',
            __('Associated Comparison Table', 'affililabs'),
            array($this, 'render'),
            $post_types,
            'side',
            'default'
        );
    }
    
    public function render($post) {
        wp_nonce_field('affl_save_post_comparison_table_data', 'affl_post_comparison_table_nonce');
        
        $associated_table_id = get_post_meta($post->ID, '_affl_associated_comparison_table', true);
        
        $comparison_tables = get_posts(array(
            'post_type' => AFFILILABS_CPT_COMPARISON_TABLE,
            'numberposts' => -1,
            'orderby' => 'title',
            'order' => 'ASC'
        ));
        
        ?>
        <p><?php affl_print(esc_html__('Select a comparison table to associate with this post/page. This will allow you to use the comparison table shortcode.', 'affililabs')); ?></p>
        
        <select name="affl_associated_comparison_table" id="affl_associated_comparison_table" style="width: 100%;">
            <option value=""><?php affl_print(esc_html__('-- None --', 'affililabs')); ?></option>
            <?php foreach ($comparison_tables as $table) : ?>
                <option value="<?php affl_print(esc_attr($table->ID)); ?>" <?php selected($associated_table_id, $table->ID); ?>>
                    <?php affl_print(esc_html($table->post_title)); ?>
                </option>
            <?php endforeach; ?>
        </select>
        
        <?php if (!empty($associated_table_id)) : ?>
            <p>
                <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-list-edit&list_id=' . $associated_table_id), 'affl_admin_nonce', 'nonce'))); ?>" target="_blank" class="button button-small">
                    <?php affl_print(esc_html__('Edit Table', 'affililabs')); ?>
                </a>
            </p>
        <?php endif; ?>
        <?php
    }
    
    public function save($post_id) {
        if (!isset($_POST['affl_post_comparison_table_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['affl_post_comparison_table_nonce'])), 'affl_save_post_comparison_table_data')) {
            AFFL_LoggerService::log('Nonce verification failed for post comparison table data', 'WARNING');
            return $post_id;
        }
        
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            AFFL_LoggerService::log('Autosave detected for post comparison table data', 'WARNING');
            return $post_id;
        }
        
        if (isset($_POST['post_type']) && 'page' === $_POST['post_type']) {
            if (!current_user_can('edit_page', $post_id)) {
                AFFL_LoggerService::debug('User does not have edit_page permissions for post comparison table data');
                return $post_id;
            }
        } else {
            if (!current_user_can('edit_post', $post_id)) {
                AFFL_LoggerService::debug('User does not have edit_post permissions for post comparison table data');
                return $post_id;
            }
        }
        
        if (isset($_POST['affl_associated_comparison_table'])) {
            $table_id = sanitize_text_field(wp_unslash($_POST['affl_associated_comparison_table']));
            if (!empty($table_id)) {
                update_post_meta($post_id, '_affl_associated_comparison_table', $table_id);
            } else {
                delete_post_meta($post_id, '_affl_associated_comparison_table');
            }
        }
        else {
            AFFL_LoggerService::debug('No associated comparison table selected for post comparison table data');
        }
        AFFL_LoggerService::debug('Post comparison table data saved');

        return $post_id;
    }
}

new AFFLMetaboxPostComparisonTable(); 
