/**
 * AffiliLabs Spinner Component
 *
 * This script provides a simple spinner for loading states.
 * Must be explicitly called when needed.
 */
jQuery(document).ready(function($) {
  const $spinner = $('#affililabs-spinner');
  const $icon = $('.affililabs-spinner__icon');
  const $text = $('.affililabs-spinner__text');
  const $close_button = $spinner.find('.affililabs-spinner__close-btn');

  const svg_types = {
    blocks: '',
    wifi: '',
    pulse: ''
  };
  
  function cache_initial_svgs() {
    const blocks_container = $('[data-svg-type="blocks"]');
    const wifi_container = $('[data-svg-type="wifi"]');
    const pulse_container = $('[data-svg-type="pulse"]');
    
    if (blocks_container.length) svg_types.blocks = blocks_container.html();
    if (wifi_container.length) svg_types.wifi = wifi_container.html();
    if (pulse_container.length) svg_types.pulse = pulse_container.html();
  }
  
  cache_initial_svgs();
  
  /**
   * Shows the spinner
   *
   * @param {string} message - Optional text to display with the spinner
   * @param {string} type - Optional spinner type to use
   */
  function show_spinner(message = '', type = null) {
    if (!$spinner.closest('.affililabs-plugin__main, main').length) {
      const $main = $('.affililabs-plugin__main');
      if ($main.length) {
        $spinner.appendTo($main);
      } else {
        const $outermost_main = $('main').first();
        if ($outermost_main.length) {
          $spinner.appendTo($outermost_main);
        }
      }
    }
    
    if (message) {
      $text.text(message);
      $text.show();
    } else {
      $text.hide();
    }

    if (!type) {
      type = ['blocks', 'wifi', 'pulse'][Math.floor(Math.random() * 3)];
    }
    
    if (['blocks', 'wifi', 'pulse'].includes(type)) {
      $icon.attr('data-spinner-type', type);
      
      if (svg_types[type]) {
        $icon.html(svg_types[type]);
      }
    }
    
    if (!$spinner.hasClass('affililabs-spinner--show')) {
      $spinner.addClass('affililabs-spinner--show');
    }

    setTimeout(function () {
      if (!$spinner.hasClass('affililabs-spinner--show')) return;
      $spinner.find('.affililabs-spinner__close-button-bottom').show();
    }, 7000);
  }
  
  function hide_spinner() {
    $spinner.removeClass('affililabs-spinner--show');
    $spinner.find('.affililabs-spinner__close-button-bottom').hide();
  }

  if ($close_button.length) {
    $close_button.on('click', function() {
      hide_spinner();
    });
  }

  $('.affililabs-spinner__close-button-bottom').on('click', function(){
    hide_spinner();
  });


  $(document).on('keydown', function(event) {
    if ((event.key === "Escape" || event.keyCode === 27) && $spinner.hasClass('affililabs-spinner--show')) {
      hide_spinner();
    }
  });
  
  window.affililabs_spinner = {
    show: show_spinner,
    hide: hide_spinner
  };
});
