<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AffiliLabs_Sidebar {

  public function load_scripts() {
    wp_enqueue_style('affililabs-sidebar', AFFILILABS_SIDEBAR_COMPONENT_CSS_URL, array(), AFFILILABS_VERSION, 'all');
    wp_enqueue_script('affililabs-sidebar', AFFILILABS_SIDEBAR_COMPONENT_JS_URL, array(), AFFILILABS_VERSION, true);
    wp_localize_script('affililabs-sidebar', 'affililabs_assets', array(
        'arrow_left_svg' => AFFILILABS_ASSETS_ARROW_LEFT_SVG,
    ));
    wp_add_inline_style('affililabs-sidebar', '
      .affililabs-plugin-dashboard__sidebar {
        height: 100vh;
      }
      .affililabs-plugin-dashboard__logo img {
        width: 30px;
        height: auto;
      }
      .affililabs-plugin-dashboard__nav-item img {
        width: 16px;
        height: auto;
      }
    ');
  }

  /**
   * Renders the AffiliLabs sidebar component.
   *
   * This function generates the HTML structure for the sidebar, including the logo, dropdown menu, navigation items, and plan details.
   *
   * @param string $activated_item The key of the currently activated navigation item.
   * @return void
   */
  public function render($activated_item='dashboard') { ?>
    <aside class="affililabs-plugin-dashboard__sidebar">
      <div class="affililabs-plugin-dashboard__logo">
          <img width="30" src="<?php affl_print(AFFILILABS_ASSETS_LOGO_LIGHT); ?>" alt="AffiliLabs logo">
          <h2>
              <span class="affililabs-plugin-dashboard__sidebar-plugin__first-name">Affili</span><span class="affililabs-plugin-dashboard__sidebar-plugin__last-name">Labs</span>
          </h2>
      </div>
      <button class="affililabs-plugin-dashboard__sidebar-toggle">
        <img src="<?php affl_print(AFFILILABS_ASSETS_ARROW_LEFT_SVG); ?>" alt="Toggle Sidebar">
      </button>
      <nav class="affililabs-plugin-dashboard__nav">
          <ul>
              <?php
              $nav_items = array(
                  array(
                      'key' => 'dashboard',
                      'page' => 'affililabs',
                      'title' => esc_html__('Dashboard', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_HOUSE_LIGHT_SVG,
                      'alt' => esc_html__('Dashboard', 'affililabs'),
                      'activated' => $activated_item === 'dashboard'
                  ),
                  array(
                      'key' => 'marketplaces',
                      'page' => 'affililabs-marketplaces',
                      'title' => esc_html__('Marketplaces', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_PRICE_TAG_SVG,
                      'alt' => esc_html__('Marketplaces', 'affililabs'),
                      'activated' => $activated_item === 'marketplaces'
                  ),
                  array(
                      'key' => 'product-categories',
                      'page' => 'affililabs-product-categories',
                      'title' => esc_html__('Categories', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_HIERARCHY_CIRCLE_SVG,
                      'alt' => esc_html__('Product Categories', 'affililabs'),
                      'activated' => $activated_item === 'product-categories'
                  ),
                  array(
                      'key' => 'products',
                      'page' => 'affililabs-products',
                      'title' => esc_html__('Products', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_LETTER_P_SVG,
                      'alt' => esc_html__('Products', 'affililabs'),
                      'activated' => $activated_item === 'products'
                  ),
                  array(
                      'key' => 'lists',
                      'page' => 'affililabs-lists',
                      'title' => esc_html__('Lists', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_CHECKLIST_SVG,
                      'alt' => esc_html__('Lists', 'affililabs'),
                      'activated' => $activated_item === 'lists'
                  ),
                  array(
                      'key' => 'templates',
                      'page' => 'affililabs-templates',
                      'title' => esc_html__('Templates', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_PENCIL_RULER_SVG,
                      'alt' => esc_html__('Templates', 'affililabs'),
                      'activated' => $activated_item === 'templates'
                  ),
                   array(
                      'key' => 'criteria',
                      'page' => 'affililabs-criteria',
                      'title' => esc_html__('Criteria', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_COPY_SVG,
                      'alt' => esc_html__('Criteria', 'affililabs'),
                      'activated' => $activated_item === 'criteria'
                  ),
                  array(
                      'key' => 'classic-links',
                      'page' => 'affililabs-classic-links',
                      'title' => esc_html__('Classic Links', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_SHIELD_CHECK_SVG,
                      'alt' => esc_html__('Classic Links', 'affililabs'),
                      'activated' => $activated_item === 'classic-links'
                  ),
                  array(
                      'key' => 'logs',
                      'page' => 'affililabs-logs',
                      'title' => esc_html__('Logs', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_DOCUMENT_SVG,
                      'alt' => esc_html__('Logs', 'affililabs'),
                      'activated' => $activated_item === 'logs'
                  ),
                  array(
                      'key' => 'settings',
                      'page' => 'affililabs-settings',
                      'title' => esc_html__('Settings', 'affililabs'),
                      'svg' => AFFILILABS_ASSETS_GEAR_SVG,
                      'alt' => esc_html__('Settings', 'affililabs'),
                      'activated' => $activated_item === 'settings'
                  ),
              );
              foreach ($nav_items as $nav_item):
                  $nav_item_class = "affililabs-plugin-dashboard__nav-item";
                  if ($nav_item['activated']) {
                      $nav_item_class .= " affililabs-plugin-dashboard__nav-item--active";
                  }
                  ?>
                  <li class="<?php affl_print($nav_item_class); ?>">
                      <a href="<?php affl_print(admin_url('admin.php?page=' . $nav_item['page'])); ?>">
                          <img src="<?php affl_print($nav_item['svg']); ?>" alt="<?php affl_print($nav_item['alt']); ?>">
                          <?php affl_print($nav_item['title']); ?>
                      </a>
                  </li>
              <?php endforeach; ?>
          </ul>
      </nav>
      <div class="affililabs-plugin-dashboard__plan">
          <div class="affililabs-plugin-dashboard__pro-plan-container">
              <?php if (affl_fs()->is_not_paying()) : ?>
                <?php if (affl_fs()->is_trial()) : ?>
                    <span><?php affl_print(esc_html__('Trial Plan', 'affililabs')); ?></span>
                <?php else : ?>
                    <span><?php affl_print(esc_html__('Free Plan', 'affililabs')); ?></span>
                <?php endif; ?>
                <?php $upgrade_url = affl_fs()->get_upgrade_url(); ?>
                <a href="<?php affl_print(esc_url($upgrade_url)); ?>">
                    <button class="affililabs-plugin-dashboard__pro-plan-button">Upgrade</button>
                </a>
              <?php else: ?>
                <span><?php affl_print(esc_html__('Pro Plan', 'affililabs')); ?></span>
              <?php endif; ?>
          </div>
          <hr class="affililabs-plugin-dashboard__nav-separator" />
          <div class="affililabs-plugin-dashboard__plan-details">
              <?php
              $display_text = esc_html__('1 / 1', 'affililabs');
              $progress_value = 1;
              $progress_max = 1;

              try {
                  if (affl_fs()->can_use_premium_code()) {
                      $license = affl_fs()->_get_license();

                      if (is_object($license)) {
                          $total_allowed_installations = $license->quota;
                          $current_installations       = $license->total_activations();

                          if ($license->is_unlimited()) {
                              $display_text = esc_html__('Unlimited Websites', 'affililabs');
                              $progress_value = 1;
                              $progress_max = 1;
                          } else {
                              $display_text = "{$current_installations} / {$total_allowed_installations}";
                              $progress_value = $current_installations;
                              $progress_max = $total_allowed_installations;
                          }
                      }
                  }
              } catch (Throwable $e) {
                  if (class_exists('AFFL_LoggerService')) {
                      AFFL_LoggerService::debug('Freemius license check failed: ' . esc_html($e->getMessage()));
                  }
                  $display_text = esc_html__('1 / 1', 'affililabs');
                  $progress_value = 1;
                  $progress_max = 1;
              }
              ?>
              <span><?php affl_print(esc_html__('Websites', 'affililabs')); ?></span>
              <span><?php affl_print($display_text); ?></span>
          </div>
          <progress value="<?php affl_print($progress_value); ?>" max="<?php affl_print($progress_max); ?>"></progress>
      </div>
    </aside>
  <?php
  }
}
