<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AffiliLabs_Navbar {

  public function load_scripts() {
    wp_enqueue_style('affililabs-navbar', AFFILILABS_NAVBAR_COMPONENT_CSS_URL, array(), AFFILILABS_VERSION, 'all');
    wp_enqueue_script('affililabs-navbar', AFFILILABS_NAVBAR_COMPONENT_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
    wp_localize_script(
      'affililabs-navbar',
      'affililabs_navbar_data',
      array(
        'nonce' => wp_create_nonce('affl_admin_nonce'),
        'i18n' => array(
          'no_notifications_text' => esc_html__('No notifications', 'affililabs'),
          'loading_text' => esc_html__('Loading...', 'affililabs'),
          'ai_credits_text' => esc_html__('AI Credits:', 'affililabs'),
          'no_usage_data_text' => esc_html__('No usage data available.', 'affililabs'),
          'failed_load_usage_text' => esc_html__('Failed to load usage data.', 'affililabs'),
          'error_load_usage_text' => esc_html__('Error loading usage data.', 'affililabs'),
        ),
      )
    );
    wp_add_inline_style('affililabs-navbar', '
      .affililabs-plugin-dashboard__main-nav-item img {
        width: 16px;
        height: auto;
      }
      .affililabs-plugin-dashboard__main-nav-user img {
        width: 30px;
        height: 30px;
        margin-left: 10px;
        border-radius: 50%;
      }
    ');
  }

  public function render() { ?>
    <nav class="affililabs-plugin-dashboard__main-nav">
      <ul>
        <li class="affililabs-plugin-dashboard__main-nav-item">
          <a href="https://affililabs.ai" class="affililabs-plugin-dashboard__main-nav-info" target="_blank" rel="noopener noreferrer nofollow"><img width="16" src="<?php affl_print(AFFILILABS_ASSETS_QUESTION_MARK_SVG); ?>" alt="More information"></a>
        </li>
        <li class="affililabs-plugin-dashboard__main-nav-item">
          <a href="#" class="affililabs-plugin-dashboard__main-nav-notification"><img width="16" src="<?php affl_print(AFFILILABS_ASSETS_SPEAKER_SVG); ?>" alt="Notifications"></a>
          <div class="affililabs-plugin-dashboard__notification-popup" style="display: none;">
            <p><?php affl_print(esc_html__('No notifications', 'affililabs')); ?></p>
          </div>
        </li>
        <?php if (affl_fs()->can_use_premium_code()) : ?>
        <li class="affililabs-plugin-dashboard__main-nav-item">
          <a href="#" class="affililabs-plugin-dashboard__main-nav-usage"><img width="16" src="<?php affl_print(AFFILILABS_ASSETS_MEMO_SVG); ?>" alt="Usage"><span><?php affl_print(esc_html__('Usage', 'affililabs')); ?></span></a>
          <div class="affililabs-plugin-dashboard__usage-popup" style="display: none;">
            <p><?php affl_print(esc_html__('Loading...', 'affililabs')); ?></p>
          </div>
        </li>
        <li class="affililabs-plugin-dashboard__main-nav-item">
          <a href="<?php affl_print(admin_url('admin.php?page=affililabs-account')); ?>"
            class="affililabs-plugin-dashboard__main-nav-plan"><?php affl_print(esc_html__('Pro', 'affililabs')); ?></a>
        </li>
        <?php endif; ?>
        <li class="affililabs-plugin-dashboard__main-nav-item">
          <a href="<?php
            affl_print(
              affl_fs()->can_use_premium_code()
                ? admin_url('admin.php?page=affililabs-account')
                : '#'
            );
          ?>" class="affililabs-plugin-dashboard__main-nav-user">
            <span><?php affl_print(ucfirst(esc_html(wp_get_current_user()->display_name ?? wp_get_current_user()->user_nicename))); ?></span>
            <?php affl_print(get_avatar(get_current_user_id(), 20)); ?>
          </a>
        </li>
      </ul>
    </nav>
  <?php
  }
}

