jQuery(document).ready(function($) {
  const notification_icon = $('.affililabs-plugin-dashboard__main-nav-notification');
  const notification_popup = $('.affililabs-plugin-dashboard__notification-popup');

  notification_icon.on('click', function(e) {
    e.preventDefault();
    notification_popup.toggle();
  });

  // Close the popup when clicking outside of it
  $(document).on('click', function(e) {
    if (!notification_popup.is(e.target) && notification_popup.has(e.target).length === 0 && !notification_icon.is(e.target) && notification_icon.has(e.target).length === 0) {
      notification_popup.hide();
    }
  });

  if (typeof affililabs_navbar_data !== 'undefined' && affililabs_navbar_data.nonce) {
      const {
          loading_text,
          ai_credits_text,
          no_usage_data_text,
          failed_load_usage_text,
          error_load_usage_text
      } = affililabs_navbar_data.i18n;

      const usage_element = $('.affililabs-plugin-dashboard__main-nav-usage span');
      const usage_icon = $('.affililabs-plugin-dashboard__main-nav-usage');
      const usage_popup = $('.affililabs-plugin-dashboard__usage-popup');

      usage_icon.on('click', function(e) {
          e.preventDefault();
          usage_popup.toggle();

          if (usage_popup.is(':visible')) {
              $.ajax({
                  url: ajaxurl,
                  type: 'POST',
                  data: {
                      action: 'affililabs_get_user_quota',
                      nonce: affililabs_navbar_data.nonce
                  },
                  success: function(response) {
                      if (response.success && response.data && response.data.credits) {
                          const credits = response.data.credits;
                          let popup_html = '';

                          if (credits.ai !== undefined) {
                              popup_html += '<p><strong>' + ai_credits_text + '</strong> ' + credits.ai + '</p>';
                          }
                          
                          // Future categories can be added here
                          // if (credits.amazon !== undefined) {
                          //    popup_html += '<p><strong>Amazon:</strong> ' + credits.amazon + '</p>';
                          // }

                          if (popup_html !== '') {
                              usage_popup.html(popup_html);
                          } else {
                               usage_popup.html('<p>' + no_usage_data_text + '</p>');
                          }
                      } else {
                           usage_popup.html('<p>' + failed_load_usage_text + '</p>');
                      }
                  },
                  error: function(err) {
                      console.error('Failed to fetch AI credits', err);
                      usage_popup.html('<p>' + error_load_usage_text + '</p>');
                  }
              });
          }
      });

      $(document).on('click', function(e) {
          if (!usage_popup.is(e.target) && usage_popup.has(e.target).length === 0 && !usage_icon.is(e.target) && usage_icon.has(e.target).length === 0) {
              usage_popup.hide();
              usage_popup.html('<p>' + loading_text + '</p>');
          }
      });
  }
});
