<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AffiliLabs_Modal {

  const TYPE_NOTICE = 'notice';
  const TYPE_CONFIRM = 'confirm';
  const TYPE_ERROR = 'error';
  const TYPE_SUCCESS = 'success';

  public function load_scripts() {
    wp_enqueue_style('affililabs-modal-css', AFFILILABS_MODAL_COMPONENT_CSS_URL, array(), AFFILILABS_VERSION, 'all');
    wp_enqueue_script('affililabs-modal-js', AFFILILABS_MODAL_COMPONENT_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
    
    wp_localize_script('affililabs-modal-js', 'affililabs_modal', array(
      'i18n' => array(
        'ok' => esc_html__('OK', 'affililabs'),
        'cancel' => esc_html__('Cancel', 'affililabs'),
        'confirm' => esc_html__('Confirm', 'affililabs'),
        'delete' => esc_html__('Delete', 'affililabs'),
        'success' => esc_html__('Success', 'affililabs'),
        'error' => esc_html__('Error', 'affililabs'),
        'warning' => esc_html__('Warning', 'affililabs'),
        'confirm_delete' => esc_html__('Are you sure you want to delete this item?', 'affililabs'),
        'action_cannot_be_undone' => esc_html__('This action cannot be undone.', 'affililabs'),
      ),
      'colors' => array(
        'primary' => '#1e3b8a',    // Primary blue
        'secondary' => '#00BFFF',  // Secondary blue
        'success' => '#28a745',    // Green success color
        'danger' => '#ff4d4d',     // Red danger color
      ),
    ));
  }

  /**
   * Renders the modal component container.
   * This method outputs the HTML structure for different modal types.
   * 
   * @return void
   */
  public function render() { ?>
    <div id="affililabs-modal" class="affililabs-modal">
      <div class="affililabs-modal__overlay"></div>
      <div class="affililabs-modal__container">
        <div class="affililabs-modal__header">
          <h3 class="affililabs-modal__title"></h3>
          <span class="affililabs-modal__close">&times;</span>
        </div>
        <div class="affililabs-modal__content"></div>
        <div class="affililabs-modal__footer">
          <div class="affililabs-modal__buttons"></div>
        </div>
      </div>
    </div>
  <?php
  }

  /**
   * Initializes the modal system by adding it to the admin footer
   */
  public function init() {
    add_action('admin_footer', array($this, 'render'));
  }
} 