<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);

class AffiliLabs_Button {

  public function load_scripts() {
    wp_enqueue_style('affililabs-navbar-css', AFFILILABS_NAVBAR_COMPONENT_CSS_URL, array(), AFFILILABS_VERSION, 'all');
  }

  public function render($text, $target_url='#', $icon_url='', $target = '_self', $class = '') { ?>

    <a class="affililabs-plugin__button <?php affl_print(esc_attr($class)); ?>" href="<?php affl_print(esc_url($target_url)); ?>" target="<?php affl_print(esc_attr($target)); ?>">
      <?php affl_print(esc_html($text)); ?>
      <?php if (!empty($icon_url)): ?>
        <img class="affililabs-plugin__button-icon" src="<?php affl_print(esc_url($icon_url)); ?>" />
      <?php endif; ?>
    </a>

  <?php 
  }

}
