<?php

/*
Plugin Name: AffiliLabs — Amazon & Digistore Product Review Affiliate Plugin Powered by AI
Plugin URI: https://affililabs.ai
Description: AffiliLabs provides complete solutions for your affiliate marketing needs assisted with AI.
Version: 0.7.10
Author: AffiliLabs
Author URI: https://affililabs.ai
Text Domain: affililabs
Domain Path: /languages
License: MIT
License URI: https://opensource.org/license/mit
*/
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'affl_fs' ) ) {
    affl_fs()->set_basename( false, __FILE__ );
    // important for Freemius logic separation
} else {
    // Create a helper function for easy SDK access.
    function affl_fs() {
        global $affl_fs;
        if ( !isset( $affl_fs ) ) {
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
            $affl_fs = fs_dynamic_init( array(
                'id'               => '16031',
                'slug'             => 'affililabs',
                'type'             => 'plugin',
                'public_key'       => 'pk_7bf6bae78b0c711865e04c622102e',
                'is_premium'       => false,
                'premium_suffix'   => 'Professional',
                'has_addons'       => false,
                'has_paid_plans'   => true,
                'trial'            => array(
                    'days'               => 7,
                    'is_require_payment' => true,
                ),
                'is_org_compliant' => true,
                'has_affiliation'  => 'selected',
                'menu'             => array(
                    'slug' => 'affililabs',
                ),
                'is_live'          => true,
            ) );
        }
        return $affl_fs;
    }

    // Init Freemius.
    affl_fs();
    // Signal that SDK was initiated.
    do_action( 'affl_fs_loaded' );
    try {
        function affl_handle_critical_errors() {
            $error = error_get_last();
            $critical_errors = [
                E_ERROR,
                E_PARSE,
                E_COMPILE_ERROR,
                E_CORE_ERROR
            ];
            // E_USER_ERROR
            if ( isset( $error['type'] ) && in_array( $error['type'], $critical_errors ) ) {
                $prefix = '[' . gmdate( 'Y-m-d H:i:s' ) . "UTC] [AffiliLabs]::CRITICAL_ERROR: ";
                $upload_dir = wp_upload_dir();
                $file = trailingslashit( $upload_dir['basedir'] ) . 'affililabs-logs/error.log';
                if ( !file_exists( dirname( $file ) ) ) {
                    wp_mkdir_p( dirname( $file ) );
                }
                error_log( $prefix . esc_html( $error['message'] ) . "\n", 3, $file );
                deactivate_plugins( plugin_basename( __FILE__ ) );
            }
        }

        register_shutdown_function( 'affl_handle_critical_errors' );
        function affl_import(  $file  ) {
            if ( !(include_once $file) ) {
                throw new Exception('Failed to import file: ' . esc_html( $file ));
            }
        }

        function affl_get_allowed_html_tags() {
            static $allowed_tags = null;
            if ( $allowed_tags === null ) {
                $allowed_tags = wp_kses_allowed_html( 'post' );
                // Extensive list for backend/form usage
                $form_tags = array(
                    'select'   => array(
                        'id'       => true,
                        'name'     => true,
                        'class'    => true,
                        'style'    => true,
                        'disabled' => true,
                        'data-tab' => true,
                        'multiple' => true,
                    ),
                    'option'   => array(
                        'value'    => true,
                        'selected' => true,
                        'disabled' => true,
                    ),
                    'input'    => array(
                        'type'        => true,
                        'id'          => true,
                        'name'        => true,
                        'value'       => true,
                        'class'       => true,
                        'style'       => true,
                        'placeholder' => true,
                        'checked'     => true,
                        'pattern'     => true,
                        'readonly'    => true,
                        'disabled'    => true,
                        'required'    => true,
                        'step'        => true,
                        'min'         => true,
                        'max'         => true,
                    ),
                    'textarea' => array(
                        'id'          => true,
                        'name'        => true,
                        'class'       => true,
                        'style'       => true,
                        'rows'        => true,
                        'cols'        => true,
                        'placeholder' => true,
                        'readonly'    => true,
                        'disabled'    => true,
                    ),
                    'label'    => array(
                        'for'   => true,
                        'class' => true,
                        'style' => true,
                    ),
                    'button'   => array(
                        'type'          => true,
                        'id'            => true,
                        'class'         => true,
                        'name'          => true,
                        'value'         => true,
                        'data-save-tab' => true,
                        'data-tab'      => true,
                        'data-action'   => true,
                        'disabled'      => true,
                    ),
                    'iframe'   => array(
                        'src'             => true,
                        'width'           => true,
                        'height'          => true,
                        'frameborder'     => true,
                        'allow'           => true,
                        'allowfullscreen' => true,
                        'style'           => true,
                        'class'           => true,
                        'id'              => true,
                    ),
                );
                $allowed_tags = array_merge( $allowed_tags, $form_tags );
                // Ensure container and layout tags have common attributes
                $layout_tags = array(
                    'div',
                    'section',
                    'main',
                    'header',
                    'footer',
                    'aside',
                    'nav',
                    'span'
                );
                foreach ( $layout_tags as $tag ) {
                    if ( !isset( $allowed_tags[$tag] ) ) {
                        $allowed_tags[$tag] = array();
                    }
                    $allowed_tags[$tag] = array_merge( $allowed_tags[$tag], array(
                        'class'            => true,
                        'id'               => true,
                        'style'            => true,
                        'data-tab-content' => true,
                        'data-tab'         => true,
                        'data-save-tab'    => true,
                    ) );
                }
                // Ensure images have expected attributes
                $allowed_tags['img'] = array_merge( $allowed_tags['img'] ?? array(), array(
                    'src'    => true,
                    'alt'    => true,
                    'width'  => true,
                    'height' => true,
                    'style'  => true,
                    'class'  => true,
                    'id'     => true,
                ) );
                // Ensure links have common data attributes
                $allowed_tags['a'] = array_merge( $allowed_tags['a'] ?? array(), array(
                    'href'       => true,
                    'title'      => true,
                    'class'      => true,
                    'target'     => true,
                    'id'         => true,
                    'style'      => true,
                    'data-nonce' => true,
                    'data-id'    => true,
                ) );
            }
            return $allowed_tags;
        }

        function affl_print(  $element  ) {
            $allowed_tags = affl_get_allowed_html_tags();
            ob_start();
            print wp_kses( $element, $allowed_tags );
            $output = ob_get_clean();
            if ( strpos( $output, 'Warning:' ) !== false || strpos( $output, 'Error:' ) !== false ) {
                $prefix = '[' . gmdate( 'Y-m-d H:i:s' ) . "UTC] [AffiliLabs]::ERROR: ";
                $warning_log = $prefix . 'Output contains warnings or errors: ' . $output;
                $upload_dir = wp_upload_dir();
                $file = trailingslashit( $upload_dir['basedir'] ) . 'affililabs-logs/error.log';
                if ( !file_exists( dirname( $file ) ) ) {
                    wp_mkdir_p( dirname( $file ) );
                }
                error_log( esc_html( $warning_log ), 3, $file );
            }
            print wp_kses( $output, $allowed_tags );
        }

        /**
         * Sanitizes a float input, supporting both comma and dot as decimal separators.
         *
         * @param string|int|float $input The value to sanitize.
         * @return float The sanitized float value. Returns 0.0 if the input is not a valid number.
         */
        function affl_sanitize_float_input(  $input  ) : float {
            if ( is_float( $input ) || is_int( $input ) ) {
                return (float) $input;
            }
            if ( !is_string( $input ) || $input === '' ) {
                return 0.0;
            }
            $cleaned_value = $input;
            $last_dot_position = strrpos( $cleaned_value, '.' );
            $last_comma_position = strrpos( $cleaned_value, ',' );
            if ( $last_dot_position !== false && $last_comma_position !== false ) {
                if ( $last_comma_position > $last_dot_position ) {
                    $cleaned_value = str_replace( '.', '', $cleaned_value );
                    $cleaned_value = str_replace( ',', '.', $cleaned_value );
                } else {
                    $cleaned_value = str_replace( ',', '', $cleaned_value );
                }
            } elseif ( $last_comma_position !== false ) {
                $cleaned_value = str_replace( ',', '.', $cleaned_value );
            }
            $non_digits_regex = '/[^\\d.]/';
            $cleaned_value = preg_replace( $non_digits_regex, '', $cleaned_value );
            return (float) $cleaned_value;
        }

        define( 'AFFILILABS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
        define( 'AFFILILABS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
        define( 'AFFILILABS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
        define( 'AFFILILABS_PLUGIN_FILE', __FILE__ );
        define( 'AFFILILABS_VERSION', affl_fs()->get_plugin_version() );
        affl_import( AFFILILABS_PLUGIN_PATH . 'modules/constants/path.php' );
        affl_import( AFFILILABS_SERVICES_LOGGER_FILE );
        affl_import( AFFILILABS_MODEL_AFFILILABS_FILE );
        affl_import( AFFILILABS_CPT_MARKETPLACE_FILE );
        affl_import( AFFILILABS_CPT_PRODUCT_FILE );
        affl_import( AFFILILABS_CPT_CRITERION_FILE );
        affl_import( AFFILILABS_CPT_COMPARISON_TABLE_FILE );
        affl_import( AFFILILABS_CPT_TEMPLATE_FILE );
        affl_import( AFFILILABS_SHORTCODE_PRODUCT_BOX_FILE );
        affl_import( AFFILILABS_SHORTCODE_PRODUCT_FIELDS_FILE );
        affl_import( AFFILILABS_COMPARISON_TABLE_SHORTCODE_PATH );
        affl_import( AFFILILABS_SHORTCODE_SEAL_FILE );
        affl_import( AFFILILABS_POST_COMPARISON_TABLE_METABOX_FILE );
        affl_import( AFFILILABS_AJAX_CONTROLLER );
        affl_import( AFFILILABS_SERVICE_OPTIMIZEPRESS_FILE );
        affl_import( AFFILILABS_SERVICE_CLEANUP_FILE );
        add_action( 'plugins_loaded', function () {
            global $affililabs;
            if ( !isset( $affililabs ) ) {
                $affililabs = new AffiliLabs();
            }
        } );
        register_activation_hook( AFFILILABS_PLUGIN_FILE, array('AffiliLabs', 'activate_plugin') );
    } catch ( Throwable $e ) {
        if ( class_exists( 'AFFL_LoggerService' ) ) {
            AFFL_LoggerService::log( esc_html( $e->getMessage() ) );
        } else {
            $upload_dir = wp_upload_dir();
            $file = trailingslashit( $upload_dir['basedir'] ) . 'affililabs-logs/error.log';
            if ( !file_exists( dirname( $file ) ) ) {
                wp_mkdir_p( dirname( $file ) );
            }
            error_log( "[" . gmdate( 'Y-m-d H:i:s' ) . "UTC] [AffiliLabs]::ERROR: " . esc_html( $e->getMessage() ) . "\n", 3, $file );
            error_log( "[" . gmdate( 'Y-m-d H:i:s' ) . "UTC] [AffiliLabs]::ERROR: " . esc_html( $e->getMessage() ) . "\n" );
        }
    }
}