<?php
defined('WP_UNINSTALL_PLUGIN') || exit;

global $wpdb, $wp_filesystem;

// Load filesystem API
if (empty($wp_filesystem)) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
    WP_Filesystem();
}

// Delete plugin options
delete_option('aegis_shield_cron_enabled');
delete_option('aegis_shield_cron_frequency');
delete_option('aegis_shield_last_cron_scan');
delete_option('aegis_shield_license_key');
delete_option('aegis_shield_failed_logins');

// Remove custom scan and block files
$upload_dir = wp_upload_dir();
$log_dir = trailingslashit($upload_dir['basedir']) . 'aegis-shield/';

if (is_dir($log_dir)) {
    $files = glob($log_dir . '*');
    foreach ($files as $file) {
        if (is_file($file)) {
            wp_delete_file($file);
        }
    }
    // Remove directory itself
    $wp_filesystem->rmdir($log_dir, true);
}

