<?php
defined('ABSPATH') || exit;

/**
 * Check a file for suspicious code patterns.
 *
 * @param string $file_path
 * @return array Array of matched patterns with line numbers
 */
function aegis_shield_check_suspicious_code($file_path) {
    $suspicious_patterns = [
        'eval\('            => 'Use of eval()',
        'base64_decode\('   => 'Use of base64_decode()',
        'shell_exec\('      => 'Use of shell_exec()',
        'exec\('            => 'Use of exec()',
        'passthru\('        => 'Use of passthru()',
        'system\('          => 'Use of system()',
        'proc_open\('       => 'Use of proc_open()',
        'popen\('           => 'Use of popen()',
        'assert\('          => 'Use of assert() as function',
        'create_function\(' => 'Use of create_function()',
        'gzinflate\('       => 'Use of gzinflate()',
        'str_rot13\('       => 'Use of str_rot13()',
    ];

    $matches = [];

    $lines = file($file_path); // Read file into lines

    foreach ($lines as $line_number => $line) {
        foreach ($suspicious_patterns as $pattern => $description) {
            if (preg_match("/$pattern/i", $line)) {
                $matches[] = [
                    'line'        => $line_number + 1,
                    'pattern'     => $pattern,
                    'description' => $description,
                    'snippet'     => trim($line),
                ];
            }
        }
    }

    return $matches;
}
