<?php
defined('ABSPATH') || exit;

/**
 * Main scan runner for Aegis Shield.
 */
function aegis_shield_run_scan() {
    $root_path = ABSPATH;
    $results = [
        'scanned_files'      => 0,
        'suspicious_matches' => [],
        'integrity_issues'   => [],
    ];

    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($root_path, RecursiveDirectoryIterator::SKIP_DOTS)
    );

    foreach ($iterator as $file) {
        if ($file->getExtension() !== 'php') {
            continue;
        }

        $file_path = $file->getRealPath();
        $results['scanned_files']++;

        // Run integrity check first
        $integrity_status = aegis_shield_check_file_integrity($file_path);

        if ($integrity_status === 'new' || $integrity_status === 'changed') {
            $results['integrity_issues'][] = [
                'file'  => $file_path,
                'issue' => ucfirst($integrity_status) . ' file',
            ];

            // Only check suspicious code in new/changed files
            $suspicious = aegis_shield_check_suspicious_code($file_path);
            if (!empty($suspicious)) {
                $results['suspicious_matches'][] = [
                    'file'    => $file_path,
                    'matches' => $suspicious,
                ];
            }
        }
    }
    
        $scan_dir = AEGIS_SHIELD_LOG_DIR . '/scans/';

        global $wp_filesystem;
        if (empty($wp_filesystem)) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            WP_Filesystem();
        }

        if (!$wp_filesystem->is_dir($scan_dir)) {
            $wp_filesystem->mkdir($scan_dir, FS_CHMOD_DIR, true);
        }

        $file_path = $scan_dir . 'scan-' . gmdate('Ymd-Hi') . '.json';
        file_put_contents($file_path, json_encode($results, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));



    return $results;
}

