jQuery(function ($) {
    $('#aegis-run-scan').on('click', function (e) {
        e.preventDefault();

        $('#aegis-scan-progress').show();
        $('#aegis-scan-bar').css('width', '10%');
        $('#aegis-scan-status').text('Initializing scan...');

        $.post(AegisAjax.ajax_url, {
            action: 'aegis_run_scan',
            _ajax_nonce: AegisAjax.nonce
        }, function (response) {
            $('#aegis-scan-bar').css('width', '100%');
            $('#aegis-scan-status').text('Scan complete!');
            $('#aegis-scan-results').html(response.data.html);
        }).fail(function () {
            $('#aegis-scan-bar').css('background', 'red').css('width', '100%');
            $('#aegis-scan-status').text('Something went wrong. Please try again.');
        });
    });
});
