<?php
defined('ABSPATH') || exit;



const AEGIS_SHIELD_HASH_FILE = AEGIS_SHIELD_LOG_DIR . '/file-hashes.json';

/**
 * Check if a file's hash matches the last scan.
 *
 * @param string $file_path
 * @return string|null Returns message if changed, null if no issue
 */
function aegis_shield_check_file_integrity($file_path) {
    static $hash_data;

    if (!isset($hash_data)) {
        $hash_data = aegis_shield_load_hashes();
    }

    $current_hash = sha1_file($file_path);
    $relative_path = ltrim(str_replace(ABSPATH, '', $file_path), '/');

    // New file
    if (!isset($hash_data[$relative_path])) {
        $hash_data[$relative_path] = $current_hash;
        aegis_shield_save_hashes($hash_data);
        return 'new';
    }

    // Modified file
    if ($hash_data[$relative_path] !== $current_hash) {
        $hash_data[$relative_path] = $current_hash;
        aegis_shield_save_hashes($hash_data);
        return 'changed';
    }

    return 'unchanged';
}


/**
 * Load hash data from file.
 *
 * @return array
 */
function aegis_shield_load_hashes() {
    if (!file_exists(AEGIS_SHIELD_HASH_FILE)) {
        return [];
    }

    $json = file_get_contents(AEGIS_SHIELD_HASH_FILE);
    $data = json_decode($json, true);
    return is_array($data) ? $data : [];
}

/**
 * Save hash data to file.
 *
 * @param array $data
 * @return void
 */
function aegis_shield_save_hashes($data) {
    global $wp_filesystem;

    if (empty($wp_filesystem)) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
        WP_Filesystem();
    }

    $dir = dirname(AEGIS_SHIELD_HASH_FILE);

    if (!$wp_filesystem->is_dir($dir)) {
        $wp_filesystem->mkdir($dir, FS_CHMOD_DIR, true);
    }

    $wp_filesystem->put_contents(
        AEGIS_SHIELD_HASH_FILE,
        json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES),
        FS_CHMOD_FILE
    );
}

