<?php
// cron-handler.php

defined('ABSPATH') || exit;

add_action('aegis_shield_cron_scan', 'aegis_shield_run_scheduled_scan');

/**
 * Run a scan and email results to the admin in HTML format
 */
function aegis_shield_run_scheduled_scan() {
    $results = aegis_shield_run_scan();

    $subject = 'Aegis Shield Scan Report';
    $body = '<h2>Aegis Shield Daily Scan Report</h2>';
    $body .= '<p><strong>Scanned:</strong> ' . esc_html($results['scanned_files']) . ' PHP files.</p>';

    if (!empty($results['suspicious_matches'])) {
        $body .= '<h3>Suspicious Code Found:</h3><ul>';
        foreach ($results['suspicious_matches'] as $match) {
            $body .= '<li><strong>' . esc_html($match['file']) . '</strong><ul>';
            foreach ($match['matches'] as $m) {
                $body .= '<li>Line ' . esc_html($m['line']) . ': ' . esc_html($m['description']) . '<br><code>' . esc_html($m['snippet']) . '</code></li>';
            }
            $body .= '</ul></li>';
        }
        $body .= '</ul>';
    } else {
        $body .= '<p style="color:green;">No suspicious code found.</p>';
    }

    if (!empty($results['integrity_issues'])) {
        $body .= '<h3>Integrity Issues:</h3><ul>';
        foreach ($results['integrity_issues'] as $issue) {
            $body .= '<li><strong>' . esc_html($issue['file']) . '</strong>: ' . esc_html($issue['issue']) . '</li>';
        }
        $body .= '</ul>';
    }

    // Send email in HTML format
    wp_mail(
        get_option('admin_email'),
        $subject,
        $body,
        ['Content-Type: text/html; charset=UTF-8']
    );

    // Save last scan timestamp
    update_option('aegis_shield_last_cron_scan', current_time('mysql'));

}
