<?php
/*
Plugin Name: Aegis Shield
Plugin URI: https://aegisshield.pro
Description: Aegis Shield scans your WordPress installation for malware, file tampering, and suspicious code patterns.
Version: 1.0.2
Author: Aegis Shield LLC
Text Domain: aegis-shield
License: GPL 2.0
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

defined('ABSPATH') || exit;

// Define constants
define('AEGIS_SHIELD_PATH', plugin_dir_path(__FILE__));
define('AEGIS_SHIELD_URL', plugin_dir_url(__FILE__));
define('AEGIS_SHIELD_LOG_DIR', wp_upload_dir()['basedir'] . '/aegis-shield/');

// Includes
require_once AEGIS_SHIELD_PATH . 'includes/scanner.php';
require_once AEGIS_SHIELD_PATH . 'includes/integrity-check.php';
require_once AEGIS_SHIELD_PATH . 'includes/suspicious-code-check.php';
require_once AEGIS_SHIELD_PATH . 'includes/admin-ui.php';
require_once AEGIS_SHIELD_PATH . 'includes/cron-handler.php';
require_once AEGIS_SHIELD_PATH . 'includes/htaccess-editor.php';
//require_once AEGIS_SHIELD_PATH . 'includes/uninstall.php';

// Optional: Setup on activation
register_activation_hook(__FILE__, function () {
    if (!wp_next_scheduled('aegis_shield_cron_scan')) {
        wp_schedule_event(time(), 'daily', 'aegis_shield_cron_scan');
    }
});

register_deactivation_hook(__FILE__, function () {
    wp_clear_scheduled_hook('aegis_shield_cron_scan');
});
//protect logs directory from anyone but us
add_action('template_redirect', function () {
    $request_uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';
    if (strpos($request_uri, '/wp-content/uploads/aegis-shield/') !== false) {
        status_header(403);
        exit('Access denied.');
    }
});
