<?php
class advert_ad{
    function __construct() {
        global $advert_key;
      
        if(is_admin()){
            add_action( 'admin_enqueue_scripts', [$this,'advert_enqueue'] );
            add_filter('plugin_action_links_'.ADVERT_NAME, [$this,'advert_plugin_action_links']);
            add_action('admin_menu',[$this, 'advert_addpages']);
            
            add_action('plugins_loaded', [$this, 'advert_gonggao']);
         

        }
        register_activation_hook(ADVERT_FILE, [$this,'advert_pluginaction']);
        add_filter('advert_dhdfkdksj', [$this,'advert_dhdfkdksj']);
        add_filter('advert_dssdd', [$this,'advert_dssdd']);
        $advert_key = apply_filters('advert_dhdfkdksj',1);
        
        
    }
    public function advert_gonggao(){
        $installed = get_option('advert_db_version');
        if ($installed === ADVERT_VERSION) {
            return;
            
        }
        if($installed===false){
            add_option('advert_db_version', ADVERT_VERSIONN);
        }else{
            update_option('advert_db_version', ADVERT_VERSION);
        }
        global $wpdb;
        $charset_collate = '';
        if (!empty($wpdb->charset)) {
          $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
        }
        if (!empty( $wpdb->collate)) {
          $charset_collate .= " COLLATE {$wpdb->collate}";
        }
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        if($wpdb->get_var("show tables like '{$wpdb->prefix}advert_gonggao'") !=  $wpdb->prefix."advert_gonggao"){
            $sql4 = "CREATE TABLE " . $wpdb->prefix . "advert_gonggao (
                id bigint NOT NULL AUTO_INCREMENT,
                gid bigint default 0,
                UNIQUE KEY id (id)
            ) $charset_collate;";
            dbDelta($sql4);
        }
        
    }
    
    public function advert_enqueue($hook){
        if( 'toplevel_page_advert' != $hook ) return;
        require plugin_dir_path( ADVERT_FILE ) . 'assets.php';
        foreach($advert_assets as $key=>$val){
            if($val['type']=='css'){
                wp_enqueue_style( $val['name'],  plugin_dir_url( ADVERT_FILE ).'assets/'.$val['url'],false,ADVERT_VERSION,'all');
            }elseif($val['type']=='js'){
                wp_enqueue_script( $val['name'], plugin_dir_url( ADVERT_FILE ).'assets/'.$val['url'], '', ADVERT_VERSION, true);
            }
        }
        wp_register_script('advert.js', false, false, ADVERT_VERSION,false);
        wp_enqueue_script('advert.js');
        // $url1 = advert_ad::advert_url(0);
        $advert_is_mianze = get_option('advert_is_mianze');
        $advert_version  = esc_url_raw(admin_url('plugin-install.php?tab=plugin-information&plugin=advert-wzt'));
        $advert_is_mianze = $advert_is_mianze?$advert_is_mianze:0;
        wp_add_inline_script('advert.js', 'var advert_wztkj_url="'.esc_js(plugins_url('',ADVERT_FILE)).'",advert_nonce="'. esc_attr(wp_create_nonce('advert')).'",advert_ajax="'.esc_url(admin_url('admin-ajax.php')).'",advert_is_mianze="'.esc_js($advert_is_mianze).'",advert_version="'.esc_url_raw($advert_version).'";', 'before');
        wp_enqueue_media();
    }
    public function advert_plugin_action_links ( $links) {
        $links[] = '<a href="' . esc_url(admin_url( 'admin.php?page=advert' )) . '">设置</a>';
        return $links;
    }
    public  function advert_addpages(){
        add_menu_page(__('广告','advert-wzt'), __('广告','advert-wzt'), 'manage_options', 'advert', [$this,'advert_toplevelpage'] );
    }
    public  function advert_toplevelpage(){
        echo "<div id='advert_wztkj-app'></div>";
    }
    public function advert_pluginaction(){
        global $wpdb;
        $charset_collate = '';
        
        if (!empty($wpdb->charset)) {
          $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
        }
    
        if (!empty( $wpdb->collate)) {
          $charset_collate .= " COLLATE {$wpdb->collate}";
        }
        $sql = "CREATE TABLE " . $wpdb->prefix . "advert_liuyan (
                id int(10) NOT NULL AUTO_INCREMENT,
                time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                content text NOT NULL,
                UNIQUE KEY id (id)
            ) $charset_collate;";
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta($sql);
    }
    public function advert_dssdd($value){
        global $advert_log;
        $url =advert_ad::advert_url(0);
        if(is_string($advert_log)){
            $log = $advert_log;
        }elseif(is_array($advert_log) && isset($advert_log['log']) && $advert_log['log']){
            $log = $advert_log;
        }else{
            $log = 'wztkj';
        }
        $type = 1;
        $arr = [
            md5($url),
            md5($log),
            md5($type),
            md5($url.$log),
            md5($url.$type),
            md5($log.$url),
            md5($log.$type),
            md5($type.$url),
            md5($type.$log),
            md5($url.$log.$type),
            md5($url.$type.$log),
            md5($log.$url.$type),
            md5($log.$type.$url),
            md5($type.$url.$log),
            md5($type.$log.$url),
        ];
        return $arr;
    }
     public static function advert_get_token(){
        $advert_wzt_token1 = get_option('advert_wzt_token1');
        $advert_wzt_token2 = get_option('advert_wzt_token2');
        $advert_wzt_token3 = get_option('advert_wzt_token3');
        return [$advert_wzt_token1,$advert_wzt_token2,$advert_wzt_token3];
    }
    public static function advert_sanitizing_key($key,$arr){
        foreach ($arr as $item) {
            if (strpos($key, $item) !== false) {
                return $key;
            }
        }
        return 0;
    }
    public static function advert_sanitizing_date1($key){
        if (strlen($key) !== 104) {
            return false;
        }
    
        // 提取各部分
        $a = substr($key, 32, 2);
        $b = substr($key, 66, 2);
        $c = substr($key, 100, 4);
        $today = date_i18n('Ymd', current_time('timestamp'));
        $num = $c.$b.$a;
        if((int)$num>(int)$today){
            return $key;
        }
        return 0;
    }
    public static function advert_sanitizing_date2($key){
        if (strlen($key) !== 104) {
            return false;
        }
    
        // 提取各部分
        $a = substr($key, 32, 2);
        $b = substr($key, 66, 2);
        $c = substr($key, 100, 4);
        $today = date_i18n('Ymd', current_time('timestamp'));
        $num = $c.$a.$b;
        if((int)$num>(int)$today){
            return $key;
        }
        return 0;
    }
    public static function advert_sanitizing_date3($key){
        if (strlen($key) !== 104) {
            return false;
        }
    
        // 提取各部分
        $a = substr($key, 32, 4);
        $b = substr($key, 68, 2);
        $c = substr($key, 102, 2);
       
        $today = date_i18n('Ymd', current_time('timestamp'));
        $num = $a.$b.$c;
        if((int)$num>(int)$today){
            return $key;
        }
        return 0;
    }
    public function advert_dhdfkdksj($value){
        $arr = self::advert_get_token();
       
        $arr1 = apply_filters('advert_dssdd',2);
        $key= 0;
        foreach($arr as $k=>$v){
            
            if(self::advert_sanitizing_key($v,$arr1)){
                switch ($k) {
                    case 0:
                        $key = self::advert_sanitizing_date1($v);
                        if($key){
                            break 2;
                        }else{
                            break;
                        }
                    case 1:
                        $key = self::advert_sanitizing_date2($v);
                        if($key){
                            break 2;
                        }else{
                            break;
                        }
                    case 2:
                        $key = self::advert_sanitizing_date3($v);
                        if($key){
                            break 2;
                        }else{
                            break;
                        }
                   
                }
            }
        }
        return $key;
    }
   
    public static function advert_url($type = 0){
      $home = home_url('/');
      $parts = wp_parse_url($home);
    
      $scheme = isset($parts['scheme']) ? $parts['scheme'] : 'https';
      $host   = isset($parts['host']) ? $parts['host'] : '';
    
      // fallback：某些极端环境 parse 不到 host
      if (!$host) {
        $host = preg_replace('#^https?://#', '', rtrim($home, '/'));
        $host = explode('/', $host)[0];
      }
    
      if ($type == 1) {
        return $scheme . '://' . $host;  // origin
      }
      return $host; // host
    }

    
}
?>