<?php
class advert_head
{
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'advert_enqueue']);
        // add_action('wp_head', [$this, 'advert_headpage']);
    }


    public function advert_enqueue()
    {

       
        
        $advert_guanggao = get_option('advert_guanggao');
        if(!empty($advert_guanggao)){
             // 注册并加载JavaScript文件
            wp_register_script(
                'wztkej-advert-js',
                plugin_dir_url(ADVERT_FILE) . 'inc/js/header.js',
                array('jquery'),
                ADVERT_VERSION,
                true // 加载到页脚
            );
            // 加载脚本
            wp_enqueue_script('wztkej-advert-js');
    
            wp_add_inline_script(
                'wztkej-advert-js',
                "var advertData = '".wp_json_encode(
                    array(
                        'ad'=>[
                        'imgLink'      => esc_js(plugins_url('img/close_iocn.png',ADVERT_FILE)),
                        'imgbaiLink'      => esc_js(plugins_url('img/icon_close_bai.png',ADVERT_FILE)),
                            'left'=>isset($advert_guanggao['left']) ? (int)$advert_guanggao['left'] : "",
                            'right'=>isset($advert_guanggao['right']) ? (int)$advert_guanggao['right'] : "",
                            'bottom'=>isset($advert_guanggao['bottom']) ? (int)$advert_guanggao['bottom'] : "",
                            'mobile'=>isset($advert_guanggao['mobile']) ? (int)$advert_guanggao['mobile'] : "",
                            'bottad'=>[
                                'pic' => isset($advert_guanggao['bottad']['pic'])?esc_url($advert_guanggao['bottad']['pic']):"",
                                'link' => isset($advert_guanggao['bottad']['link'])?esc_url($advert_guanggao['bottad']['link']):"",
                                'time' => isset($advert_guanggao['bottad']['time'])?(int)$advert_guanggao['bottad']['time']:"",
                                'showtime' => isset($advert_guanggao['bottad']['showtime'])?(int)$advert_guanggao['bottad']['showtime']:"",
                            ],
                            'mobtad'=>[
                                'pic' => esc_url($advert_guanggao['mobtad']['pic']),
                                'link' => esc_url($advert_guanggao['mobtad']['link']),
                                'time' => (int)$advert_guanggao['mobtad']['time'],
                                'showtime' => (int)$advert_guanggao['mobtad']['showtime'],
                            ],
                            'leftad'=>isset($advert_guanggao['leftad']) ? array_map(
                                    function($item) {
                                        return array(
                                            'pic' => esc_url($item['pic']),
                                            'link' => esc_url($item['link']),
                                        );
                                    },
                                    $advert_guanggao['leftad']
                                ) : array(),
                            'rightad'=>isset($advert_guanggao['rightad']) ? array_map(
                                    function($item) {
                                        return array(
                                            'pic' => esc_url($item['pic']),
                                            'link' => esc_url($item['link']),
                                        );
                                    },
                                    $advert_guanggao['rightad']
                                ) : array(),
                            
                        ],
                        'ajaxUrl'      => esc_url(admin_url('admin-ajax.php')),
                        'nonce'        =>  esc_attr(wp_create_nonce('advert')),
                    )
                )."';",
                'before'
            );

        }
        wp_enqueue_script("jquery");
        wp_enqueue_style('wztkej_prism_css', plugin_dir_url(ADVERT_FILE) . 'inc/css/prism.css', false, ADVERT_VERSION, 'all');
        wp_enqueue_style('wztkej_header_css', plugin_dir_url(ADVERT_FILE) . 'inc/css/header.css', false, ADVERT_VERSION, 'all');
    }
}
