<?php
/**
 * Wallet navigation template
 *
 * This template displays the navigation menu for the wallet section in the user's account.
 *
 * @package Advanced Wallet for WooCommerce
 * @since 1.0.0
 */

defined('ABSPATH') || exit;
?>
<nav class="wallet-navigation-container">
    <div class="wallet-navigation">
        <?php foreach ($navigation as $action => $label) : 
            $class = ($current_action === $action) ? 'nav-item active' : 'nav-item';
            $url = wc_get_account_endpoint_url('wallet') . '?action=' . $action;
        ?>
            <div class="<?php echo esc_attr($class); ?>">
                <a href="<?php echo esc_url($url); ?>">
                    <span class="nav-text"><?php echo esc_html($label); ?></span>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
</nav>