<?php
/**
 * Template for Add Fund form
 *
 * @package Advanced Wallet for WooCommerce
 */

defined('ABSPATH') || exit;

// Security check
if (!is_user_logged_in()) {
    wp_redirect(wc_get_page_permalink('myaccount'));
    exit;
}
?>

<div class="pisol-wallet-add-fund-container">
    <h2 class="pisol-wallet-title"><?php esc_html_e('Add Fund to Wallet', 'advanced-wallet-for-woocommerce'); ?></h2>
    
    <form method="post" class="pisol-add-fund-form">
        <?php wp_nonce_field('pisol_add_fund_action', 'pisol_add_fund_nonce'); ?>
        
        <div class="pisol-form-field">
            <label for="pisol_fund_amount">
                <?php esc_html_e('Amount', 'advanced-wallet-for-woocommerce'); ?>
                <span class="required">*</span>
            </label>
            <input 
                type="number" 
                id="pisol_fund_amount" 
                name="pisol_fund_amount" 
                step="0.01" 
                min="<?php echo esc_attr($min_amount); ?>"
                max="<?php echo esc_attr($max_amount); ?>" 
                placeholder="<?php esc_attr_e('Enter amount', 'advanced-wallet-for-woocommerce'); ?>" 
                required
            />
        </div>
        
        <div class="pisol-form-submit">
            <button type="submit" class="button" name="pisol_add_fund_submit">
                <?php esc_html_e('Add Funds', 'advanced-wallet-for-woocommerce'); ?>
            </button>
        </div>
    </form>
</div>
