(() => {

const PISOL_Wallet = ({ cart, extensions }) => {
    //console.log(extensions);

    const initialOptions = extensions?.pisol_aww_wallet || [];


    const [options, setOptions] = React.useState(initialOptions);

    React.useEffect(() => {
        if (extensions?.pisol_aww_wallet) {
            setOptions(extensions.pisol_aww_wallet);
        }
    }, [extensions?.pisol_aww_wallet]);

    const handleCheckboxChange = (id, event) => {

        setOptions({
            ...options,
            checked: event.target.checked
        });
        
        if (event.target.checked) {
            var data = { id: id, checked: true };
        } else {
            var data = { id: id, checked: false };
        }

        document.body.classList.add('pi-aww-processing');
        wc.blocksCheckout.extensionCartUpdate({
            namespace: 'pisol_aww_wallet',
            data: data
        }).then(() => {
            document.body.classList.remove('pi-aww-processing');
        });
    };

    if (typeof extensions.pisol_aww_wallet == 'undefined') return [];

    if (extensions.pisol_aww_wallet.length == 0) return [];


    return React.createElement("div", {
        className: 'pisol-wallet-container'
    }, React.createElement("input", {
        type: "checkbox",
        id: 'use-wallet-balance',
        onChange: (e) => handleCheckboxChange('use-wallet-balance', e),
        checked: options.checked ? true : false
    }), React.createElement("label", {
        htmlFor: 'use-wallet-balance'
    }, options.message));

};

const render_pisol_wallet = () => {
    return React.createElement(wc.blocksCheckout.ExperimentalDiscountsMeta, null, React.createElement(PISOL_Wallet, null));
};

wp.plugins.registerPlugin('pisol-aww-wallet', {
    render: render_pisol_wallet,
    scope: 'woocommerce-checkout',
});

})();