// block.js
(function () {
    const settings = wc.wcSettings.getSetting('pisol_wallet_data', {});
    const el = wp.element.createElement;

    // Function component
    const PisolWalletContent = (props) => {
        return el(
            'div',
            { className: 'pisol-wallet-content' },
            settings.description || 'Pay securely using Pisol Wallet.'
        );
    };

    wc.wcBlocksRegistry.registerPaymentMethod({
        name: 'pisol_wallet', // must match $name in PHP
        label: settings.title || 'Pisol Wallet',
        ariaLabel: settings.title || 'Pisol Wallet',

        // ✅ pass element, not raw string
        content: el(PisolWalletContent),
        edit: el(PisolWalletContent),

        canMakePayment: () => true,

        supports: {
            features: ['products']
        },

        paymentMethodId: 'pisol_wallet',

    });
})();
