<?php
namespace PISOL\AWW\FRONT;
use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use PISOL\AWW\CLASSES\Wallet_Manager;

final class Wallet_Gateway_Block extends AbstractPaymentMethodType {

	protected $name = 'pisol_wallet';
    protected $gateway;

    public function initialize() {
        $this->settings = get_option( 'woocommerce_pisol_wallet_settings', array() );
        $gateways = WC()->payment_gateways()->payment_gateways();
        $this->gateway = isset( $gateways['pisol_wallet'] ) ? $gateways['pisol_wallet'] : null;
    }

    public function is_active() {
        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles() {
        return [
            'my-gateway-block-script',
        ];
    }

    public function get_payment_method_data() {
        $wallet_balance = $this->balance();
        $formatted_balance = html_entity_decode(
            wp_strip_all_tags( wc_price( $wallet_balance ) )
        );
        $sub_text = sprintf(
            __('(💼 Balance: %s)', 'advanced-wallet-for-woocommerce'),
            $formatted_balance
        );
        return [
            'title'       => $this->get_setting( 'title' ). ' '.$sub_text,
            'description' => $this->get_setting( 'description' ),
            'supports'    => [ 'products' ],
        ];
    }

    public function balance(){
        $user_id = get_current_user_id();
        $wallet_manager = Wallet_Manager::get_instance();
        $wallet_balance = $wallet_manager->get_user_balance($user_id);
        return $wallet_balance;
    }
}