<?php
namespace PISOL\AWW\FRONT;
use PISOL\AWW\CLASSES\Wallet_Manager;
use Automattic\WooCommerce\StoreApi\StoreApi;
use Automattic\WooCommerce\StoreApi\Schemas\ExtendSchema;
use Automattic\WooCommerce\StoreApi\Schemas\V1\CartSchema;
use Automattic\WooCommerce\StoreApi\Schemas\V1\CheckoutSchema;
//use Automattic\WooCommerce\StoreApi\Schemas\V1\CheckoutSchema;
//use Automattic\WooCommerce\Blocks\StoreApi\Schemas\CartSchema;
//use Automattic\WooCommerce\Blocks\StoreApi\Schemas\CheckoutSchema;


class Wallet_Block{

    private $extend;

    protected static $instance = null;

    const IDENTIFIER = 'pisol_aww_wallet';


    public static function get_instance( ) {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

    protected function __construct(){
        add_action( 'woocommerce_blocks_loaded', [$this, 'loadData']);
        add_action('wp_enqueue_scripts', [$this, 'fillCode']);
    }

    function loadData(){
	    $this->extendData();
        $this->callBack();
    }

    function extendData(){
        woocommerce_store_api_register_endpoint_data(
			array(
				'endpoint'        => CartSchema::IDENTIFIER,
				'namespace'       => self::IDENTIFIER,
				'data_callback'   => array( $this, 'optionalFees' ),
				'schema_type'       => ARRAY_A,
			)
		);
    }

    function callBack(){
        woocommerce_store_api_register_update_callback(
            [
              'namespace' => self::IDENTIFIER,
              'callback'  => [$this, 'checkboxChange']
            ]
          );
    }

    function checkboxChange( $data ){
       if($data['checked']){
            WC()->session->set('wallet_partial_checked', true);
       }else{
            WC()->session->set('wallet_partial_checked', false);
            WC()->session->set('wallet_partial_payment_amount', 0);
       }
    }

    function optionalFees(){
        if( !(function_exists('WC') && is_object(WC()->cart)) ) return [];

        if (!is_user_logged_in()) {
            return [];
        }
        
        $checked = WC()->session->get('wallet_partial_checked', false);

        $wallet_balance = $this->balance();
        $formatted_balance = html_entity_decode(
            wp_strip_all_tags( wc_price( $wallet_balance ) )
        );

        if ($wallet_balance <= 0) {
            return [];
        }

        if(Add_Fund::is_wallet_rechargeable_cart()){
            return false; // Don't show this gateway if wallet recharge product is in the cart
        }

        $raw_cart_total = self::get_raw_cart_total();
        if($raw_cart_total <= 0){
            return [];
        }

        if($raw_cart_total < $wallet_balance){
            return [];
        }

        $message = sprintf(
                    // translators: %s: Wallet balance amount
                    __('Use wallet balance (%s) for partial payment', 'advanced-wallet-for-woocommerce'),
                    $formatted_balance
        );
        
        return ['message' => $message, 'checked' => $checked ? true : false ];
    }

    static function get_raw_cart_total(){
        $obj = Wallet_Checkout::get_instance();
        $obj->store_raw_cart_total();

        // Get raw cart total (before wallet fee)
        $raw_cart_total = WC()->session->get('wallet_raw_cart_total', $obj->get_raw_cart_total());
        return $raw_cart_total;
    }

    function fillCode(){
        if(is_checkout()){
            wp_enqueue_script( 'pisol-aww-wallet-block', plugin_dir_url( __FILE__ ) . 'js/wallet-block.js', array( 'wp-plugins', 'wc-blocks-checkout' ), '1.0.0', true );
            wp_enqueue_style( 'pisol-aww-wallet-block', plugin_dir_url( __FILE__ ) . 'css/wallet-block.css', array( 'wc-blocks-style' ), '1.0.0' );
        }
    }

    public function balance(){
        $user_id = get_current_user_id();
        $wallet_manager = Wallet_Manager::get_instance();
        $wallet_balance = $wallet_manager->get_user_balance($user_id);
        return $wallet_balance;
    }

}