<?php 

namespace PISOL\AWW\FRONT;

if ( ! defined( 'WPINC' ) ) {
    die;
}

class Front_Bootstrap {
    static $instance = null;

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        // Initialize wallet checkout functionality
        add_action('init', [$this, 'init_wallet_checkout']);
        
        // Register the wallet payment gateway
        add_filter('woocommerce_payment_gateways', [$this, 'register_wallet_payment_gateway']);

        add_action( 'woocommerce_blocks_payment_method_type_registration', function( $registry ) {
            $registry->register( new Wallet_Gateway_Block() );
        } );

        add_action( 'wp_enqueue_scripts', [$this, 'my_gateway_register_block_scripts'] );
        
        // Initialize wallet transactions display
        Wallet_Transactions::get_instance();

        Wallet_Block::get_instance();

        Add_Fund::get_instance();
    }
    
    /**
     * Initialize wallet checkout functionality
     */
    public function init_wallet_checkout() {
        // Only proceed if WooCommerce is active
        if (!class_exists('WooCommerce')) {
            return;
        }
        
        // Initialize the wallet checkout handler
        Wallet_Checkout::get_instance();
    }
    
    /**
     * Register the wallet payment gateway with WooCommerce
     * 
     * @param array $gateways Array of registered gateways
     * @return array Modified array of gateways
     */
    public function register_wallet_payment_gateway($gateways) {
        // Add our custom gateway to the list
        $gateways[] = 'PISOL\AWW\FRONT\Wallet_Gateway';
        return $gateways;
    }

    function my_gateway_register_block_scripts() {
        wp_register_script(
            'my-gateway-block-script',
            plugin_dir_url( __FILE__ ) . 'js/block.js',
            [ 'wp-element', 'wc-blocks-registry', 'wc-blocks-checkout' ],  // dependencies
            '1.0.0',
            true
        );
    }
}