<?php
namespace PISOL\AWW\CLASSES;

defined('ABSPATH') || exit;

class Install {
    private static $instance = null;

    static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        add_action('admin_init', [$this, 'init']);
    }

    static function flush_rewrite_rules() {
        // Register the wallet endpoint before flushing
        add_rewrite_endpoint('wallet', EP_ROOT | EP_PAGES);
        flush_rewrite_rules();
    }

    function init() {
        // Check if WooCommerce is active
        if ( ! class_exists( '\WooCommerce' ) ) {
            return;
        }

        // Create virtual product for wallet recharge
        self::create_virtual_product();
    }

    static function create_virtual_product() {
        if ( self::wallet_recharge_product() ) {
            return; // Product already exists
        }

        // Create new virtual product
        $product = new \WC_Product_Simple();
        $product->set_name('Wallet Topup');
        $product->set_status('private'); // Not visible to public
        $product->set_catalog_visibility('hidden');
        $product->set_description('Please do not delete or update. This is auto generated product for wallet recharge. ');
        $product->set_virtual(true);
        $product->set_downloadable(false);
        $product->set_sold_individually(true);
        $product->set_manage_stock(false);
        $product->set_reviews_allowed(false);
        $product->save();

        // Save product ID for later use
        update_option('_add_wallet_recharge_product', $product->get_id());
    }

    static function wallet_recharge_product(){
        $existing_product_id = get_option('_add_wallet_recharge_product');
        $product = wc_get_product($existing_product_id);

        if ( ! $product ) {
            return false; // Product does not exist
        }

        // Check if product exists and is not trashed
        if ( $product && get_post_status( $product->get_id() ) !== 'trash' ) {
            return absint( $existing_product_id );
        }

        return false;    
    }

}
