<?php
/**
 * Plugin Name: Advanced WooCommerce Wallet & Cashback Plugin
 * Plugin URI:  https://www.piwebsolution.com/
 * Description: Add wallet functionality to your WooCommerce store. Customers can add money to their wallet and use it for purchases.
 * Version: 1.0.12
 * Author: PI Websolution
 * Author URI:  https://www.piwebsolution.com/shop
 * Text Domain: advanced-wallet-for-woocommerce
 * Domain Path: /languages
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Requires PHP: 7.2
 * WC tested up to: 10.3.5
 */

 if ( ! defined( 'WPINC' ) ) {
    die;
}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if(!is_plugin_active( 'woocommerce/woocommerce.php')){
    add_action( 'admin_notices', function () {
        ?>
        <div class="error notice">
            <p><?php esc_html_e( '⚠️ Please Install and Activate WooCommerce plugin, without that this plugin cant work', 'advanced-wallet-for-woocommerce' ); ?></p>
        </div>
        <?php
    } );
    return;
}

if(!function_exists('pisol_aww_error_log')){
    function pisol_aww_error_log($message, $context = 'custom') {
        if (class_exists('WC_Logger')) {
            $logger = wc_get_logger();
            $logger->error(is_string($message) ? $message : wp_json_encode($message), array('source' => 'Advanced Wallet for WooCommerce', 'context' => $context));
        }
    }
}

/**
 * Declare compatible with HPOS new order table 
 */
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

define( 'PISOL_AWW_VERSION', '1.0.12' );
define( 'PISOL_AWW_FOLDER_URL', plugin_dir_url( __FILE__ ));
define( 'PISOL_AWW_FOLDER_PATH', plugin_dir_path( __FILE__ ));
define( 'PISOL_AWW_FOLDER_NAME',  dirname( plugin_basename( __FILE__ ) ));
define( 'PISOL_AWW_PLUGIN_NAME',  'auto-assign-order-tags-for-woocommerce');

define( 'PISOL_AWW_WOOCOMMERCE_PLUGIN_FOLDER', plugin_basename( __DIR__ ) );
define( 'PISOL_AWW_WOOCOMMERCE_PLUGIN_PATH', plugin_basename( __FILE__ ) );
define( 'PISOL_AWW_WOOCOMMERCE_PLUGIN_FILE',  __FILE__  );

add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ),  function ( $links ) {
    $links = array_merge( array(
        '<a href="' . esc_url( admin_url( '/admin.php?page=advanced-wallet-for-woocommerce' ) ) . '">' . __( 'Settings', 'advanced-wallet-for-woocommerce' ) . '</a>',
        '<a style="color:#0a9a3e; font-weight:bold;" target="_blank" href="https://wordpress.org/support/plugin/advanced-wallet-for-woocommerce/reviews/?filter=5#wp-bbp_topic_content-wrap">' . __( 'GIVE SUGGESTION','advanced-wallet-for-woocommerce' ) . '</a>'
    ), $links );
    return $links;
} );

register_activation_hook( __FILE__, function () {
    add_option('pi_aww_do_activation_redirect', true);
} );

add_action('admin_init', function (){
    if (get_option('pi_aww_do_activation_redirect', false)) {
        delete_option('pi_aww_do_activation_redirect');
        if(!isset($_GET['activate-multi']))
        {
            wp_redirect("admin.php?page=advanced-wallet-for-woocommerce");
        }
    }
});



require __DIR__ . '/vendor/autoload.php';

// Initialize database manager
PISOL\AWW\CLASSES\Database_Manager::get_instance();

// Initialize cashback functionality
PISOL\AWW\CLASSES\Cashback::get_instance();
PISOL\AWW\CLASSES\Review_Reward::get_instance();
PISOL\AWW\CLASSES\Registration_Reward::get_instance();
PISOL\AWW\CLASSES\Wallet_Coupon::get_instance();

// Initialize admin and frontend
PISOL\AWW\ADMIN\Admin_Bootstrap::get_instance();
PISOL\AWW\FRONT\Front_Bootstrap::get_instance();

PISOL\AWW\CLASSES\Install::get_instance();

// Flush rewrite rules on plugin activation to register custom endpoints
register_activation_hook(__FILE__, function() {

    PISOL\AWW\CLASSES\Install::flush_rewrite_rules();
    
});






