jQuery(function($){
	// Initialize SelectWoo for multiselect fields
	$('.multiselect').each(function() {
		$(this).selectWoo({
			width: '100%',
			placeholder: $(this).data('placeholder') || 'Select options',
			allowClear: true,
			dropdownAutoWidth: true
		});
	});
	
	// Initialize user email search using SelectWoo
	var $userSelect = $('#filter-user-select');
	if ($userSelect.length) {
		$userSelect.selectWoo({
			width: 'resolve',
			placeholder: 'Search by email',
			allowClear: true,
			ajax: {
				url: ajaxurl,
				dataType: 'json',
				delay: 250,
				data: function(params) {
					return {
						action: 'pisol_aww_search_users',
						term: params.term,
						pisol_aww_search_users_nonce: $('#pisol_aww_search_users_nonce').val()
					};
				},
				processResults: function(data) {
					return {
						results: $.map(data, function(item) {
							return { id: item.id, text: item.text };
						})
					};
				},
				cache: true
			}
		});
	}
		/**
	 * Toggle visibility of settings rows based on an enable/disable checkbox
	 * Hides all rows except the one containing the enable checkbox when disabled
	 * 
	 * @param {string} checkboxId - The ID of the checkbox that toggles visibility
	 * @param {string} rowId - The ID of the row containing the checkbox
	 */
	function toggleSettingsVisibility(checkboxId, rowId) {
		var $checkbox = $(checkboxId);
		var $settingRow = $(rowId);
		
		function updateRows() {
			if($settingRow.length === 0) {
				return; // Exit if the setting row doesn't exist
			}
			
			if ($checkbox.is(':checked')) {
				$('.row').show(); // Show all rows when checked
			} else {
				$('.row').hide(); // Hide all rows when unchecked
				$settingRow.show(); // Always show the enable checkbox row
			}
		}
		
		// Initial visibility state
		updateRows();
		
		// Update on checkbox change
		$checkbox.on('change', updateRows);
	}
	
	/**
	 * Toggle visibility of a target element based on a select field's value
	 * 
	 * @param {string} selectId - The ID of the select element that controls visibility
	 * @param {string} targetId - The ID of the element to show/hide
	 * @param {string} hideValue - The value of the select that should hide the target element
	 */
	function toggleElementVisibility(selectId, targetId, hideValue) {
		var $select = $(selectId);
		var $target = $(targetId);
		
		function updateVisibility() {
			if($select.length === 0 || $target.length === 0) {
				return; // Exit if elements don't exist
			}
			
			if ($select.val() === hideValue) {
				$target.hide(); // Hide target when select has hideValue
			} else {
				$target.show(); // Show target for all other values
			}
		}
		
		// Initial visibility state
		updateVisibility();
		
		// Update on select change
		$select.on('change', updateVisibility);
	}
	
	// Initialize cashback settings visibility
	toggleSettingsVisibility('#pisol_aww_enable_cashback', '#row_pisol_aww_enable_cashback');
	
	
	
	
	/**
	 * Handle transaction delete button
	 */
	$('.delete-transaction').on('click', function(e) {
		e.preventDefault();
		
		var $button = $(this);
		var transactionId = $button.data('transaction-id');
		var transactionType = $button.data('transaction-type');
		
		// Confirmation dialog
		if (!confirm(pisol_aww_i18n.delete_transaction_confirm)) {
			return;
		}
		
		// Disable button to prevent multiple clicks
		$button.prop('disabled', true).text(pisol_aww_i18n.deleting);
		
		// Send AJAX request
		$.ajax({
			url: ajaxurl,
			type: 'POST',
			data: {
				action: 'pisol_aww_soft_delete_transaction',
				transaction_id: transactionId,
				transaction_type: transactionType,
				action_type: 'delete',
				security: $('#pisol_aww_soft_delete_nonce').val()
			},
			success: function(response) {
				if (response.success) {
					// Show success message
					alert(response.data.message);
					
					// Reload the page to show updated status and balance
					window.location.reload();
				} else {
					// Re-enable button
					$button.prop('disabled', false).text(pisol_aww_i18n.delete);
					
					// Show error message
					alert(response.data.message);
				}
			},
			error: function() {
				// Re-enable button
				$button.prop('disabled', false).text(pisol_aww_i18n.delete);
				
				// Show generic error message
				alert(pisol_aww_i18n.error_message);
			}
		});
	});
	
	/**
	 * Handle transaction undelete button
	 */
	$('.undelete-transaction').on('click', function(e) {
		e.preventDefault();
		
		var $button = $(this);
		var transactionId = $button.data('transaction-id');
		var transactionType = $button.data('transaction-type');
		
		// Confirmation dialog
		if (!confirm(pisol_aww_i18n.undelete_transaction_confirm)) {
			return;
		}
		
		// Disable button to prevent multiple clicks
		$button.prop('disabled', true).text(pisol_aww_i18n.undeleting);
		
		// Send AJAX request
		$.ajax({
			url: ajaxurl,
			type: 'POST',
			data: {
				action: 'pisol_aww_soft_delete_transaction',
				transaction_id: transactionId,
				transaction_type: transactionType,
				action_type: 'undelete',
				security: $('#pisol_aww_soft_delete_nonce').val()
			},
			success: function(response) {
				if (response.success) {
					// Show success message
					alert(response.data.message);
					
					// Reload the page to show updated status and balance
					window.location.reload();
				} else {
					// Re-enable button
					$button.prop('disabled', false).text(pisol_aww_i18n.undelete);
					
					// Show error message
					alert(response.data.message);
				}
			},
			error: function() {
				// Re-enable button
				$button.prop('disabled', false).text(pisol_aww_i18n.undelete);
				
				// Show generic error message
				alert(pisol_aww_i18n.error_message);
			}
		});
	});

	// Show/hide gateway charge fields based on enable checkbox
	function toggleGatewayChargeFields() {
		var $checkbox = $('#pisol_aww_enable_gateway_charge');
		var $fieldsDiv = $('#row_pisol_aww_gateway_charge_type, #row_pisol_aww_payment_gateway_charges');
		if ($checkbox.length && $fieldsDiv.length) {
			function updateVisibility() {
				if ($checkbox.is(':checked')) {
					$fieldsDiv.show();
				} else {
					$fieldsDiv.hide();
				}
			}
			// Initial state
			updateVisibility();
			// On change
			$checkbox.on('change', updateVisibility);
		}
	}

	// Call the function on document ready
	$(toggleGatewayChargeFields);

	// Initialize tax class visibility based on tax status
	toggleElementVisibility('#wallet_product_taxable', '#row_wallet_product_tax_class', 'none');
	
	// Initialize recharge wallet settings visibility
	toggleSettingsVisibility('#pisol_aww_enable_recharge', '#row_pisol_aww_enable_recharge');
});