<?php
namespace PISOL\AWW\ADMIN;

if ( ! defined( 'ABSPATH' ) ) exit;

class Wallet_Refund_Option extends Option {

   protected static $instance = null;

    public $tab_position = 3;

    public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

    public function get_tab_name() {
        return __('Refund to Wallet', 'advanced-wallet-for-woocommerce');
    }

    public function get_tab() {
        return 'wallet_refund';
    }

    public function get_setting_key() {
        return 'wallet_refund';
    }

    public function get_icon() {
        return plugin_dir_url( __FILE__ ) . 'img/refund-icon.svg';
    }

    function __construct(){
        parent::__construct();    
    }

    function init_settings(){
        $this->settings = [
            ['field'=>'title', 'class'=> 'bg-dark2 text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("Refund to Wallet",'advanced-wallet-for-woocommerce'), 'type'=>"setting_category"],
            [
                'field' => 'pisol_aww_refund_expiry_days',
                'label' => __('Refund Expiry (Days)', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 0,
                'min' => '0',
                'desc' => __(
                    'Enter number of days before refund expires (0 = never expires). <br>For example, if set to 30 and refund is issued on 1st Jan, then the amount credited in the wallet will expire on 31st Jan.',
                    'advanced-wallet-for-woocommerce'
                )
            ],
        ];
    }
}

