<?php
namespace PISOL\AWW\ADMIN;
use PISOL\AWW\CLASSES\Wallet_Manager;
use PISOL\AWW\CLASSES\Email;

defined('ABSPATH') || exit;

class Wallet_Refund {
    private static $instance = null;

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    protected function __construct() {
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
        add_action( 'wp_ajax_aww_wallet_refund', array( $this, 'wallet_refund' ) );
    }

    public function enqueue_admin_scripts($hook) {
        global $wp_query, $post, $theorder;
        $screen    = get_current_screen();
        $screen_id = $screen ? $screen->id : '';
        if ( in_array( $screen_id, array( 'shop_order', 'woocommerce_page_wc-orders' ), true ) ) {
                $order_id = 0;
				if ( $theorder instanceof \WC_Order ) {
					$order_id = $theorder->get_id();
				} elseif ( is_a( $post, 'WP_Post' ) && 'shop_order' === get_post_type( $post ) ) {
					$order_id = $post->ID;
				}

				$order = wc_get_order( $order_id );
				if ( $order ) {
                    wp_enqueue_script( 'aww-refund-to-wallet', plugin_dir_url( __FILE__ ) . 'js/admin-order.js', array( 'jquery', 'wc-admin-order-meta-boxes' ), '1.0.0', true );
					$order_localizer = array(
						'order_id'       => $order_id,
						'payment_method' => $order->get_payment_method( 'edit' ),
						'default_price'  => wc_price( 0 ),
						'is_refundable'  => true,
						'i18n'           => array(
							'refund'     => __( 'Refund', 'add-coupon-by-link-woocommerce' ),
							'via_wallet' => __( 'to wallet', 'add-coupon-by-link-woocommerce' ),
						),
					);
					wp_localize_script( 'aww-refund-to-wallet', 'aww_wallet_admin_order_param', $order_localizer );
				}
                
        }
        
    }

    public function wallet_refund() {
        ob_start();

        check_ajax_referer( 'order-item', 'security' );
        if ( ! current_user_can( 'edit_shop_orders' ) ) {
            wp_die( -1 );
        }

        $order_id               = isset( $_POST['order_id'] ) ? absint( $_POST['order_id'] ) : 0;
        $refund_amount          = isset( $_POST['refund_amount'] ) ? wc_format_decimal( sanitize_text_field( wp_unslash( $_POST['refund_amount'] ) ), wc_get_price_decimals() ) : 0;
        $refunded_amount        = isset( $_POST['refunded_amount'] ) ? wc_format_decimal( sanitize_text_field( wp_unslash( $_POST['refunded_amount'] ) ), wc_get_price_decimals() ) : 0;
        $refund_reason          = isset( $_POST['refund_reason'] ) ? sanitize_text_field( wp_unslash( $_POST['refund_reason'] ) ) : '';
        $line_item_qtys         = isset( $_POST['line_item_qtys'] ) ? json_decode( sanitize_text_field( wp_unslash( $_POST['line_item_qtys'] ) ), true ) : array();
        $line_item_totals       = isset( $_POST['line_item_totals'] ) ? json_decode( sanitize_text_field( wp_unslash( $_POST['line_item_totals'] ) ), true ) : array();
        $line_item_tax_totals   = isset( $_POST['line_item_tax_totals'] ) ? json_decode( sanitize_text_field( wp_unslash( $_POST['line_item_tax_totals'] ) ), true ) : array();
        $api_refund             = isset( $_POST['api_refund'] ) && 'true' === $_POST['api_refund'];
        $restock_refunded_items = isset( $_POST['restock_refunded_items'] ) && 'true' === $_POST['restock_refunded_items'];
        $refund                 = false;
        $response               = array();

        try {
            $order      = wc_get_order( $order_id );
            $max_refund = wc_format_decimal( $order->get_total() - $order->get_total_refunded(), wc_get_price_decimals() );

            if ( ( ! $refund_amount && ( wc_format_decimal( 0, wc_get_price_decimals() ) !== $refund_amount ) ) || $max_refund < $refund_amount || 0 > $refund_amount ) {
                throw new Exception( __( 'Invalid refund amount', 'woocommerce' ) );
            }

            if ( wc_format_decimal( $order->get_total_refunded(), wc_get_price_decimals() ) !== $refunded_amount ) {
                throw new Exception( __( 'Error processing refund. Please try again.', 'woocommerce' ) );
            }

            
            $line_items = array();
            $item_ids   = array_unique( array_merge( array_keys( $line_item_qtys ), array_keys( $line_item_totals ) ) );

            foreach ( $item_ids as $item_id ) {
                $line_items[ $item_id ] = array(
                    'qty'          => 0,
                    'refund_total' => 0,
                    'refund_tax'   => array(),
                );
            }
            foreach ( $line_item_qtys as $item_id => $qty ) {
                $line_items[ $item_id ]['qty'] = max( $qty, 0 );
            }
            foreach ( $line_item_totals as $item_id => $total ) {
                $line_items[ $item_id ]['refund_total'] = wc_format_decimal( $total );
            }
            foreach ( $line_item_tax_totals as $item_id => $tax_totals ) {
                $line_items[ $item_id ]['refund_tax'] = array_filter( array_map( 'wc_format_decimal', $tax_totals ) );
            }
            $refund_reason = $refund_reason ? $refund_reason : __( 'Wallet refund #', 'advanced-wallet-for-woocommerce' ) . $order->get_order_number();
            
            $refund = wc_create_refund(
                array(
                    'amount'         => $refund_amount,
                    'reason'         => $refund_reason,
                    'order_id'       => $order_id,
                    'line_items'     => $line_items,
                    'refund_payment' => $api_refund,
                    'restock_items'  => $restock_refunded_items,
                )
            );
            if ( ! is_wp_error( $refund ) ) {
                
                $transaction_id = $this->add_refund_to_wallet($refund_amount, $refund_reason, $order);
                if ( ! $transaction_id ) {
                    throw new Exception( __( 'Refund not credited to customer', 'advanced-wallet-for-woocommerce' ) );
                } else {
                    Email::send_email(
                        $order->get_billing_email(),
                        sprintf( __( 'Refund for Order #%s', 'advanced-wallet-for-woocommerce' ), $order->get_order_number() ),
                        sprintf( __( 'A refund of %s has been credited to your wallet for order #%s.', 'advanced-wallet-for-woocommerce' ), wc_price( $refund_amount, array( 'currency' => $order->get_currency() ) ), $order->get_order_number() ),
                        __( 'Refund Notification', 'advanced-wallet-for-woocommerce' )
                    );
                    do_action( 'pisol_aww_order_refunded_to_wallet', $order, $refund, $transaction_id );
                }
            }

            if ( is_wp_error( $refund ) ) {
                throw new Exception( $refund->get_error_message() );
            }

            if ( did_action( 'woocommerce_order_fully_refunded' ) ) {
                $response['status'] = 'fully_refunded';
            }
        } catch ( Exception $e ) {
            wp_send_json_error( array( 'error' => $e->getMessage() ) );
        }
        // wp_send_json_success must be outside the try block not to break phpunit tests.
        wp_send_json_success( $response );
    }

    function refund_expiry_days($order){
        $expiry_days = absint(get_option('pisol_aww_refund_expiry_days', 0));
        if ($expiry_days > 0) {
            $expiry_date = gmdate('Y-m-d', strtotime("+$expiry_days days"));
            return $expiry_date;
        }
        return false;
    }

    function add_refund_to_wallet($amount, $reason, $order){
        $user_id = $order->get_customer_id();
        $order_id = $order->get_id();
        $currency = $order->get_currency('edit');
        $refund_expiry_date = self::refund_expiry_days($order);

        $credit_params = array(
            "user_id" => $user_id,
            "amount" => $amount,
            "currency" => $currency,
            "source" => "purchase",
            /* translators: %s: order number */
            "note" => $reason
        );

        if ($refund_expiry_date) {
            $credit_params['expiry_date'] = $refund_expiry_date;
        }

        $wallet_manager = Wallet_Manager::get_instance();
        $credit_id = $wallet_manager->add_credit($credit_params);
        if (!$credit_id) {
            if (function_exists('pisol_aww_error_log')) {
                pisol_aww_error_log(sprintf('Failed to add refund amount to wallet for order %s', $order->get_order_number()), 'wallet');
            }
            return false;
        }

        return $credit_id;
    }

}
