<?php
namespace PISOL\AWW\ADMIN;

class Wallet_Coupon_Option extends Option {

    static $instance = null;

    public $tab_position = 6;

    static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        parent::__construct();
    }

    public function get_tab_name() {
        return __('Wallet Coupon', 'advanced-wallet-for-woocommerce');
    }

    public function get_tab() {
        return 'wallet_coupon';
    }

    public function get_setting_key() {
        return 'wallet_coupon';
    }

    public function get_icon() {
        return plugin_dir_url( __FILE__ ) . 'img/coupon-icon.svg';
    }

    public function init_settings() {
        $this->settings = array(
            array('field'=>'title', 'class'=> 'bg-dark2 text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("Wallet coupon setting",'advanced-wallet-for-woocommerce'), 'type'=>"setting_category"),
               [
                'field' => 'pisol_aww_wallet_coupon_order_states',
                'label' => __('Order states', 'advanced-wallet-for-woocommerce'),
                'type' => 'multiselect',
                'value' => [
                    'pending' => __('Pending payment', 'advanced-wallet-for-woocommerce'),
                    'on-hold' => __('On hold', 'advanced-wallet-for-woocommerce'),
                    'processing' => __('Processing', 'advanced-wallet-for-woocommerce'),
                    'completed' => __('Completed', 'advanced-wallet-for-woocommerce')
                ],
                'default' => ['completed', 'processing'],
                'desc' => __('Select order status to credit wallet coupon amount to user wallet', 'advanced-wallet-for-woocommerce')
            ],

        );
    }
}

