<?php 

namespace PISOL\AWW\ADMIN;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Wallet_Coupon {
    private static $instance = null;

    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('edit_form_after_editor', array($this, 'render_auto_apply_section'));
        // Add checkbox field
        //add_action('woocommerce_coupon_options', [$this, 'add_wallet_coupon_checkbox']);
        
        // Save checkbox value
        add_action('woocommerce_coupon_options_save', [$this, 'save_wallet_coupon_checkbox']);
    }

    public function render_auto_apply_section($post) {
        // Only render on shop_coupon post type
        if (!$post || 'shop_coupon' !== $post->post_type) {
            return;
        }

        $coupon_id = $post->ID;
        $is_auto_apply = get_post_meta($coupon_id, '_pi_aww_is_wallet_coupon', true);
        ?>
        <div id="pisol_aww_wallet_coupon" class="pisol-aww-wallet_coupon" style="border-left:2px solid #007cba; padding: 10px; margin-top: 20px; background-color: #f9f9f9;">
            <h3><?php esc_html_e('Credit to Wallet?', 'advanced-wallet-for-woocommerce'); ?></h3>
            <div class="auto-apply-option">
                <input type="checkbox" id="pisol_aww_wallet_coupon" name="_pi_aww_is_wallet_coupon" value="yes" <?php checked($is_auto_apply, 'yes'); ?> />
                <label for="pisol_aww_wallet_coupon">
                    <?php esc_html_e('Credit the coupon discount amount into wallet credit', 'advanced-wallet-for-woocommerce'); ?>
                </label>
            </div>
        </div>
        <?php
    }

    public function add_wallet_coupon_checkbox() {
        woocommerce_wp_checkbox([
            'id'          => '_pi_aww_is_wallet_coupon',
            'label'       => __('Credit to Wallet?', 'your-textdomain'),
            'description' => __('Credit the coupon discount amount into wallet credit', 'your-textdomain'),
        ]);
    }

    public function save_wallet_coupon_checkbox($post_id) {
        $is_wallet = isset($_POST['_pi_aww_is_wallet_coupon']) ? 'yes' : 'no';
        update_post_meta($post_id, '_pi_aww_is_wallet_coupon', $is_wallet);
    }
}

