<?php
namespace PISOL\AWW\ADMIN;

class Review_Reward_Option extends Option {

    static $instance = null;

    public $tab_position = 3;

    static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        parent::__construct();
    }

    public function get_tab_name() {
        return __('Review reward', 'advanced-wallet-for-woocommerce');
    }

    public function get_tab() {
        return 'review_reward';
    }

    public function get_setting_key() {
        return 'review_reward';
    }

    public function get_icon() {
        return plugin_dir_url( __FILE__ ) . 'img/review-icon.svg';
    }

    public function init_settings() {
        $this->settings = array(
            array('field'=>'title', 'class'=> 'bg-dark2 text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("Give reward for product review",'advanced-wallet-for-woocommerce'), 'type'=>"setting_category"),
                [
                    'field' => 'pisol_aww_enable_review_reward',
                    'label' => __('Review Reward Program', 'advanced-wallet-for-woocommerce'),
                    'type' => 'switch',
                    'default' => false,
                    'desc' => __('Run review reward program on your store', 'advanced-wallet-for-woocommerce')
                ],
                [
                    'field' => 'pisol_aww_review_reward_amount',
                    'label' => __('Reward Amount', 'advanced-wallet-for-woocommerce'),
                    'type' => 'number',
                    'default' => 0,
                    'desc' => __('Amount to reward for each product review', 'advanced-wallet-for-woocommerce'),
                    'min' => 0
                ],
                [
                    'field' => 'pisol_aww_review_reward_expires_in_days',
                    'label' => __('Review Reward Expiration (Days)', 'advanced-wallet-for-woocommerce'),
                    'type' => 'number',
                    'default' => 30,
                    'desc' => __('Number of days before the review reward expires', 'advanced-wallet-for-woocommerce'),
                    'min' => 0
                ],
                [
                    'field' => 'pisol_aww_single_reward_per_product',
                    'label' => __('Single Reward Per Product', 'advanced-wallet-for-woocommerce'),
                    'type' => 'switch',
                    'default' => false,
                    'desc' => __('Allow only one reward per product review, Once enabled Customer can place multiple review for the same product but he wont get rewarded again.', 'advanced-wallet-for-woocommerce')
                ],

        );
    }
}

