<?php
namespace PISOL\AWW\ADMIN;

class Registration_Reward_Option extends Option {

    static $instance = null;

    public $tab_position = 4;

    static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        parent::__construct();
    }

    public function get_tab_name() {
        return __('Registration reward', 'advanced-wallet-for-woocommerce');
    }

    public function get_tab() {
        return 'registration_reward';
    }

    public function get_setting_key() {
        return 'registration_reward';
    }

    public function get_icon() {
        return plugin_dir_url( __FILE__ ) . 'img/registration-icon.svg';
    }

    public function init_settings() {
        $this->settings = array(
            array('field'=>'title', 'class'=> 'bg-dark2 text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("Give reward for creating account",'advanced-wallet-for-woocommerce'), 'type'=>"setting_category"),
                [
                    'field' => 'pisol_aww_enable_registration_reward',
                    'label' => __('Registration Reward Program', 'advanced-wallet-for-woocommerce'),
                    'type' => 'switch',
                    'default' => false,
                    'desc' => __('Run registration reward program on your store', 'advanced-wallet-for-woocommerce')
                ],
                [
                    'field' => 'pisol_aww_registration_reward_amount',
                    'label' => __('Reward Amount', 'advanced-wallet-for-woocommerce'),
                    'type' => 'number',
                    'default' => 0,
                    'desc' => __('Amount to reward for registration', 'advanced-wallet-for-woocommerce'),
                    'min' => 0
                ],
                [
                    'field' => 'pisol_aww_registration_reward_expires_in_days',
                    'label' => __('Registration Reward Expiration (Days)', 'advanced-wallet-for-woocommerce'),
                    'type' => 'number',
                    'default' => 30,
                    'desc' => __('Number of days before the registration reward expires', 'advanced-wallet-for-woocommerce'),
                    'min' => 0
                ]
        );
    }
}

