<?php
namespace PISOL\AWW\ADMIN;

use PISOL\AWW\CLASSES\Install;

if ( ! defined( 'ABSPATH' ) ) exit;

class Recharge_Wallet_Option  extends Option  {
    protected static $instance = null;

    public $tab_position = 2;

    public function get_tab_name() {
        return __('Recharge Wallet', 'advanced-wallet-for-woocommerce');
    }

    public function get_tab() {
        return 'recharge_wallet';
    }

    public function get_setting_key() {
        return 'recharge_wallet';
    }

    public function get_icon() {
        return plugin_dir_url( __FILE__ ) . 'img/recharge-icon.svg';
    }

    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        parent::__construct();  
    }

    function init_settings(){
        $product_id = get_option('_add_wallet_recharge_product');
        $product = wc_get_product($product_id);

        if ( ! $product ) {
            Install::create_virtual_product();
            $product_id = get_option('_add_wallet_recharge_product');
            $product = wc_get_product($product_id);
        }

        $title = $product ? $product->get_name() : '';
        $taxable = $product ? $product->get_tax_status() : '';

        if($taxable !== 'none' && $taxable !== 'taxable') {
            $taxable = 'none'; 
        }

        $tax_class = $product ? $product->get_tax_class() : '';

        $this->settings = [
              ['field'=>'title', 'class'=> 'bg-dark2 text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("Recharge Wallet",'advanced-wallet-for-woocommerce'), 'type'=>"setting_category"],
            [
                'field' => 'pisol_aww_enable_recharge',
                'label' => __('Enable Recharge Feature', 'advanced-wallet-for-woocommerce'),
                'type' => 'switch',
                'default' => false,
                'desc' => __('When enabled, customers can add funds to their wallet from their account page. Disabling this will hide the recharge option from customers but won\'t affect existing wallet balances.', 'advanced-wallet-for-woocommerce')
            ],
            [
                'field' => 'wallet_product_title',
                'label' => __('Product Title', 'advanced-wallet-for-woocommerce'),
                'type' => 'text',
                'desc' => __('The name of the product that will appear in cart and checkout when customers recharge their wallet.', 'advanced-wallet-for-woocommerce'),
                'default' => $title
            ],
            [
                'field' => 'wallet_product_taxable',
                'label' => __('Product Taxable', 'advanced-wallet-for-woocommerce'),
                'type' => 'select',
                'value' => [
                    'taxable' => __('Taxable', 'advanced-wallet-for-woocommerce'),
                    'none' => __('None', 'advanced-wallet-for-woocommerce'),
                ],
                'default' => $taxable
            ],
            [
                'field' => 'wallet_product_tax_class',
                'label' => __('Product Tax Class', 'advanced-wallet-for-woocommerce'),
                'type' => 'select',
                'value' => $this->tax_classes(),
                'desc' => __('Select a tax class for wallet recharge product. Standard refers to the default tax class.', 'advanced-wallet-for-woocommerce'),
                'default' => 'standard'
            ],
            [
                'field' => 'pisol_aww_min_recharge_amount',
                'label' => __('Minimum Recharge Amount', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 10,
                'desc' => __('Set the minimum amount that customers can add to their wallet in a single transaction. Enter 0 for no limit.', 'advanced-wallet-for-woocommerce')
            ],
            [
                'field' => 'pisol_aww_max_recharge_amount',
                'label' => __('Maximum Recharge Amount', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 0,
                'desc' => __('Set the maximum amount that customers can add to their wallet in a single transaction. Enter 0 for no upper limit.', 'advanced-wallet-for-woocommerce')
            ],
            [
                'field' => 'purhase_expiry_in_days',
                'label' => __('Expire purchased credit after x days from purchase', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 0,
                'desc' => __('Set the number of days after which the purchased credit will expire. Enter 0 for no expiration.', 'advanced-wallet-for-woocommerce')
            ],
            [
                'field' => 'pisol_aww_enable_gateway_charge',
                'label' => __('Charge customer when they add balance to their wallet?', 'advanced-wallet-for-woocommerce'),
                'type' => 'switch',
                'default' => 0,
                'desc' => __('Set a charge for each payment gateway when customers add balance to their wallet. Leave blank for no charge.', 'advanced-wallet-for-woocommerce')
            ],
            [
                'field' => 'pisol_aww_gateway_charge_type',
                'label' => __('Charge type', 'advanced-wallet-for-woocommerce'),
                'type' => 'select',
                'value' => [
                    'percentage' => __('Percentage', 'advanced-wallet-for-woocommerce'),
                    'fixed' => __('Fixed', 'advanced-wallet-for-woocommerce')
                ],
                'default' => 'fixed',
                'desc' => __('Select gateway charge type percentage or fixed', 'advanced-wallet-for-woocommerce')
            ],
            [
                'field' => 'pisol_aww_payment_gateway_charges',
                'label' => __('Gateway Charges', 'advanced-wallet-for-woocommerce'),
                'type' => 'aww_gateway_fees',
                'desc' => __('Enter gateway charge amount for each payment gateway. Leave blank for no charge.', 'advanced-wallet-for-woocommerce'),
            ]
        ];
    }

    function tax_classes() {
        $tax_classes = \WC_Tax::get_tax_classes();
        $options = [];
        foreach ($tax_classes as $tax_class) {
            $options[sanitize_title($tax_class)] = esc_html($tax_class);
        }
        return $options;
    }

    public function tab_content() {
        $product_id = get_option('_add_wallet_recharge_product');
        $product = wc_get_product($product_id);
        if ( $product ) {
            $title = get_option('wallet_product_title');
            $taxable = get_option('wallet_product_taxable', 'none');
            $tax_class = get_option('wallet_product_tax_class', 'standard');

            if ( $title && $product->get_name() !== $title ) {
                $product->set_name( $title );
                $product->set_tax_status( $taxable );
                $product->set_tax_class( $tax_class );
                $product->save();
            }
        }
        ?>
        <form method="post" action="options.php" class="pisol-setting-form">
            <?php settings_fields($this->setting_key); ?>
            <?php
            foreach ($this->settings as $setting) {
                new FormGenerator($setting, $this->setting_key);
            }
            ?>
            <input type="submit" class="mt-3 btn btn-primary btn-md" value="<?php esc_attr_e('Save Option', 'advanced-wallet-for-woocommerce'); ?>" />
        </form>
        <?php
    }
}
