<?php
namespace PISOL\AWW\ADMIN;

defined('ABSPATH') || exit;

abstract class Option {

    protected $plugin_name = 'advanced-wallet-for-woocommerce';
    protected $settings = array();
    protected $active_tab;
    protected $tab_name;
    protected $this_tab;
    protected $setting_key;
    public $tab_position = 1; // Default position for the tab

    public function __construct() {
        $this->active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'default';

        $this->this_tab = $this->get_tab();

        $this->setting_key = 'anfw_' . $this->get_setting_key() . '_settings';

        if ($this->this_tab == $this->active_tab) {
            add_action('pisol_' . $this->plugin_name . '_tab_content', array($this, 'tab_content'));
        }

        $position = $this->get_tab_postion();

        add_action('pisol_' . $this->plugin_name . '_tab', array($this, 'tab'), $position);

        add_action('admin_init', array($this, 'init_settings'), 10);
        add_action('admin_init', array($this, 'register_settings'), 20);
    }

    // Child classes must implement this to define $this->settings and $this->setting_key
    public abstract function init_settings();

    public abstract function get_tab_name();

    public abstract function get_tab();
    
    public abstract function get_setting_key();

    public abstract function get_icon();

    public function get_tab_postion(){
        return $this->tab_position;
    }

    public function register_settings() {
        foreach ($this->settings as $setting) {
            FormGenerator::register_setting($this->setting_key, $setting);
        }
    }

    public function tab() {
        $this->tab_name = $this->get_tab_name();
        $icon = $this->get_icon();
        if(!empty($icon)) {
           $img = sprintf('<img class="mr-1 pisol-icon" src="%s">', esc_url($icon));
        }
        ?>
        <a class="pi-side-menu <?php echo ($this->active_tab == $this->this_tab ? 'bg-primary' : 'bg-secondary'); ?>" href="<?php echo esc_url(admin_url('admin.php?page=' . (isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : '') . '&tab=' . $this->this_tab)); ?>">
            <?php echo isset($img) ? $img : ''; ?> <?php echo esc_html($this->tab_name); ?>
        </a>
        <?php
    }

    public function tab_content() {
        ?>
        <form method="post" action="options.php" class="pisol-setting-form">
            <?php settings_fields($this->setting_key); ?>
            <?php
            foreach ($this->settings as $setting) {
                new FormGenerator($setting, $this->setting_key);
            }
            ?>
            <input type="submit" class="mt-3 btn btn-primary btn-md" value="<?php esc_attr_e('Save Option', 'advanced-wallet-for-woocommerce'); ?>" />
        </form>
        <?php
    }
}
