<?php 
namespace PISOL\AWW\ADMIN;

if ( ! defined( 'ABSPATH' ) ) exit;

class Menu{

    public $menu;

    protected static $instance = null;

    public $plugin_name = PISOL_AWW_FOLDER_NAME;

    public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
    
    function __construct(){
        add_action( 'admin_menu', array($this,'plugin_menu') );
    }

    function plugin_menu(){
        
        $this->menu = add_menu_page(
            __( 'Wallet', 'advanced-wallet-for-woocommerce' ),
            __( 'Wallet', 'advanced-wallet-for-woocommerce' ),
            'manage_options',
            PISOL_AWW_FOLDER_NAME,
            array($this, 'menu_option_page'),
            PISOL_AWW_FOLDER_URL.'/admin/img/wallet-icon.svg',
            6
        );

        add_action("load-".$this->menu, array($this,"bootstrap_style"));
 
    }

    public function bootstrap_style() {
        
        wp_enqueue_style( PISOL_AWW_FOLDER_NAME."-bootstrap", plugin_dir_url( __FILE__ ) . 'css/bootstrap.css', array(), PISOL_AWW_VERSION, 'all' );
        
       
        // Enqueue WooCommerce admin styles with correct handle
        wp_enqueue_style('woocommerce_admin_styles');
        
        // Enqueue SelectWoo script without making it a dependency
        wp_enqueue_script('selectWoo');
        
        wp_enqueue_script( PISOL_AWW_FOLDER_NAME."-script", plugin_dir_url( __FILE__ ) . 'js/script.js', array('jquery', 'selectWoo'), PISOL_AWW_VERSION, true );
	}

    function menu_option_page(){
        if(function_exists('settings_errors')){
            settings_errors();
        }
        ?>
        <div class="bootstrap-wrapper">
        <div class="pisol-container mt-2">
            <div class="pisol-row border-bottom">
                    <div class="col-12">
                        <div class='bg-dark'>
                        <div class="pisol-row">
                            <div class="col-12 col-sm-2 py-2">
                                    <a href="https://www.piwebsolution.com/" target="_blank"><img class="img-fluid ml-2" src="<?php echo esc_url( plugin_dir_url( __FILE__ ) ); ?>img/pi-web-solution.svg"></a>
                            </div>
                            <div class="col-12 col-sm-10 d-flex">
                                
                            </div>
                        </div>
                        </div>
                    </div>
            </div>
            <div class="pisol-row">
                <div class="col-12">
                <div class="bg-light px-3">
                    <div class="pisol-row">
                        <div class="col-12 col-md-2 border-right pb-3">
                            <div id="pisol-side-menu" class="rounded">
                                <?php do_action('pisol_'.$this->plugin_name.'_tab'); ?>
                            </div>
                            <?php $this->suggestion(); ?>
                        </div>
                        <div class="col pb-3">
                            <?php do_action('pisol_'.$this->plugin_name.'_tab_content'); ?>
                        </div>
                            <?php do_action('pisol_'.$this->plugin_name.'_promotion'); ?>
                    </div>
                </div>
                </div>
            </div>
        </div>
        </div>
        <?php
    }    
    
    function suggestion(){
        ?>
        <div>
        <div class="p-3 card">
            <div class="card-body p-0">
                <h6 class="card-title"><?php esc_html_e('🙏 Give Suggestion & Feedback', 'advanced-wallet-for-woocommerce'); ?></h6>
                <p class="card-text"><?php esc_html_e('Have a suggestion to make this wallet plugin even better? We\'d love to hear it.', 'advanced-wallet-for-woocommerce'); ?></p>
                <p class="card-text"><a style="color:#0a9a3e; font-weight:bold;" target="_blank" href="https://wordpress.org/support/plugin/advanced-wallet-for-woocommerce/reviews/?filter=5#wp-bbp_topic_content-wrap"><?php esc_html_e('👉 Send us your idea', 'advanced-wallet-for-woocommerce'); ?></a></p>
                <p class="card-text"><?php esc_html_e('— we\'re actively improving the free version based on your input.', 'advanced-wallet-for-woocommerce'); ?></p>
                
            </div>
        </div>
        </div>
        <?php
    }
}