<?php
namespace PISOL\AWW\ADMIN;

class CustomFields{

    static $instance = null;

    public $allowed_tags;

    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    } 

    function __construct()
    {
        $this->allowed_tags =  wp_kses_allowed_html('post');

        $this->allowed_tags['input'] = array(
            'type'        => true,
            'name'        => true,
            'value'       => true,
            'class'       => true,
            'id'          => true,
            'placeholder' => true,
            'checked'     => true,
            'readonly'    => true,
            'disabled'    => true,
            'size'        => true,
            'maxlength'   => true,
            'min'         => true,
            'max'         => true,
            'step'        => true,
            'pattern'     => true,
            'required'    => true,
            'autocomplete'=> true,
            'autofocus'   => true,
        );

        add_action('pisol_custom_field_aww_gateway_fees', array($this,'gateways'), 10, 2);
        
    }

    function gateways($setting, $saved_value){
        $gateways = $this->gateways_options();
        foreach($gateways as $gateway => $gateway_title){
            $this->gateway_fee($setting, $saved_value, $gateway, $gateway_title);
        }
    }

    function gateway_fee($setting, $saved_value, $gateway, $gateway_title){
        $value = isset($saved_value[$gateway]) ? $saved_value[$gateway] : '';
        $label = '<label class="h6 mb-0" for="'.esc_attr($setting['field']).'['.esc_attr($gateway).']">'.wp_kses_post($gateway_title).'</label>';
        $desc =  (isset($setting['desc'])) ? '<br><small>Enter gateway charge amount for '.wp_kses_post($gateway_title).'</small>' : "";
        $field = '<input type="number" class="form-control" name="'.esc_attr($setting['field']).'['.esc_attr($gateway).']" id="'.esc_attr($setting['field']).'['.esc_attr($gateway).']" value="'.esc_attr($value).'"'
        .(isset($setting['required']) ? ' required="'.esc_attr($setting['required']).'"': '')
        .(isset($setting['readonly']) ? ' readonly="'.esc_attr($setting['readonly']).'"': '')
        .'>';
        $shortcode_html = '';

        $this->bootstrap($setting, $label, $field, $desc, $shortcode_html, 6);
    }

    function gateways_options(){
        $payment_gateways = WC()->payment_gateways->payment_gateways();
        $skip_gateways = array('pisol_wallet');
        $gateways = array();
        foreach($payment_gateways as $gateway){
            if(!in_array($gateway->id, $skip_gateways)){
                $gateways[$gateway->id] = $gateway->get_title();
            }
        }
        return $gateways;
    }

    function bootstrap($setting, $label, $field, $desc = "",$shortcode_html = '',  $title_col = 5){
        $setting_col = 12 - $title_col;
        ?>
        <div id="row_<?php echo esc_attr($setting['field']); ?>"  class="row py-4 border-bottom align-items-center <?php echo !empty($setting['class']) ? esc_attr($setting['class']) : ''; ?>">
            <div class="col-12 col-md-<?php echo esc_attr($title_col); ?>">
            <?php echo wp_kses($label, $this->allowed_tags); ?>
            <?php echo wp_kses($desc != "" ? $desc.'<br>': "", $this->allowed_tags); ?>
            <?php if(!empty($shortcode_html)): ?>
                <div class="mt-2">
                    <small><?php esc_html_e('Short codes:','pi-edd'); ?><br> <?php echo wp_kses($shortcode_html, $this->allowed_tags); ?></small>
                </div>
            <?php endif; ?>
            </div>
            <div class="col-12 col-md-<?php echo esc_attr($setting_col); ?>">
            <?php echo wp_kses($field, $this->allowed_tags); ?>
            </div>
        </div>
        <?php
    }
}