<?php
namespace PISOL\AWW\ADMIN;

if ( ! defined( 'ABSPATH' ) ) exit;

class CashBack_Option extends Option {

    protected static $instance = null;

    public $tab_position = 1;

    public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

    public function get_tab_name() {
        return __('Cash back', 'advanced-wallet-for-woocommerce');
    }

    public function get_tab() {
        return 'default';
    }

    public function get_setting_key() {
        return 'cash_back';
    }

    public function get_icon() {
        return plugin_dir_url( __FILE__ ) . 'img/cashback-icon.svg';
    }

    function __construct(){
        parent::__construct();  
    }

    function init_settings(){
        $this->settings = [
            ['field'=>'title', 'class'=> 'bg-dark2 text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("Cashback Reward",'advanced-wallet-for-woocommerce'), 'type'=>"setting_category"],
            [
                'field' => 'pisol_aww_enable_cashback',
                'label' => __('Cashback Reward Program', 'advanced-wallet-for-woocommerce'),
                'type' => 'switch',
                'default' => false,
                'desc' => __('Run cashback reward program on your store', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_process_cashback_status',
                'label' => __('Process Cashback', 'advanced-wallet-for-woocommerce'),
                'type' => 'multiselect',
                'value' => [
                    'pending' => __('Pending payment', 'advanced-wallet-for-woocommerce'),
                    'on-hold' => __('On hold', 'advanced-wallet-for-woocommerce'),
                    'processing' => __('Processing', 'advanced-wallet-for-woocommerce'),
                    'completed' => __('Completed', 'advanced-wallet-for-woocommerce')
                ],
                'default' => ['completed', 'processing'],
                'desc' => __('Select order status to process cashback', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_cashback_expiry_days',
                'label' => __('Cashback Expiry (Days)', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 0,
                'min' => '0',
                'desc' => __('Enter number of days before cashback expires (0 = never expires)', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_exclude_user_roles',
                'label' => __('Exclude User Role', 'advanced-wallet-for-woocommerce'),
                'type' => 'multiselect',
                'value' => [
                    'vendor' => __('Vendor', 'advanced-wallet-for-woocommerce'),
                    'translator' => __('Translator', 'advanced-wallet-for-woocommerce'),
                    'shop_manager' => __('Shop manager', 'advanced-wallet-for-woocommerce'),
                    'customer' => __('Customer', 'advanced-wallet-for-woocommerce'),
                    'subscriber' => __('Subscriber', 'advanced-wallet-for-woocommerce'),
                    'contributor' => __('Contributor', 'advanced-wallet-for-woocommerce'),
                    'author' => __('Author', 'advanced-wallet-for-woocommerce'),
                    'editor' => __('Editor', 'advanced-wallet-for-woocommerce'),
                    'administrator' => __('Administrator', 'advanced-wallet-for-woocommerce')
                ],
                'default' => [],
                'desc' => __('Exclude user roles from cashback program', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_cashback_rule',
                'label' => __('Cashback Rule', 'advanced-wallet-for-woocommerce'),
                'type' => 'select',
                'value' => [
                    'product' => __('Product wise', 'advanced-wallet-for-woocommerce'),
                    'category' => __('Category wise', 'advanced-wallet-for-woocommerce'),
                    'cart' => __('Cart wise', 'advanced-wallet-for-woocommerce')
                ],
                'default' => 'cart',
                'desc' => __('Select Cashback Rule', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_cashback_type',
                'label' => __('Cashback Type', 'advanced-wallet-for-woocommerce'),
                'type' => 'select',
                'value' => [
                    'fixed' => __('Fixed', 'advanced-wallet-for-woocommerce'),
                    'percentage' => __('Percentage', 'advanced-wallet-for-woocommerce')
                ],
                'default' => 'percentage',
                'desc' => __('Cashback Type', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_cashback_amount',
                'label' => __('Cashback Amount', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 0,
                'step' => '0.01',
                'min' => '0',
                'desc' => __('Enter cashback amount', 'advanced-wallet-for-woocommerce')
            ],
            
            [
                'field' => 'pisol_aww_max_cashback_amount',
                'label' => __('Maximum Cashback Amount', 'advanced-wallet-for-woocommerce'),
                'type' => 'number',
                'default' => 0,
                'step' => '0.01',
                'min' => '0',
                'desc' => __('Enter maximum cashback amount', 'advanced-wallet-for-woocommerce')
            ],
        ];
    }    
}

